/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiUserExplorationSession
implements AuthenticationSession {
    private static final long serialVersionUID = 1L;
    private final List<SimpleSession> registeredUsers = new ArrayList<SimpleSession>();
    private SimpleSession selectedUser;

    public MultiUserExplorationSession(String users) {
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            String userName;
            String token = st.nextToken();
            int end = token.indexOf(58);
            ArrayList<String> roles = new ArrayList<String>();
            if (end == -1) {
                userName = token.trim();
            } else {
                userName = token.substring(0, end).trim();
                String roleList = token.substring(end + 1);
                StringTokenizer st2 = new StringTokenizer(roleList, "|");
                while (st2.hasMoreTokens()) {
                    String role = st2.nextToken().trim();
                    roles.add(role);
                }
            }
            SimpleSession session = new SimpleSession(userName, roles.toArray(new String[roles.size()]));
            this.registeredUsers.add(session);
            if (this.selectedUser != null) continue;
            this.selectedUser = session;
        }
        if (this.registeredUsers.size() == 0) {
            throw new NakedObjectException("User string should contain at least one user");
        }
    }

    public void open() {
    }

    public void close() {
    }

    public String[] getRoles() {
        return this.selectedUser.getRoles();
    }

    public String getUserName() {
        return this.selectedUser.getUserName();
    }

    public String getValidationCode() {
        return "";
    }

    public String toString() {
        return new ToString((Object)this).append("name", this.getUserNames()).append("userCount", this.registeredUsers.size()).toString();
    }

    public void setCurrentSession(String name) {
        for (SimpleSession user : this.registeredUsers) {
            if (!user.getUserName().equals(name)) continue;
            this.selectedUser = user;
            break;
        }
    }

    public List<String> getUserNames() {
        ArrayList<String> users = new ArrayList<String>();
        for (SimpleSession user : this.registeredUsers) {
            users.add(user.getUserName());
        }
        return users;
    }

    public boolean hasMultipleUsers() {
        return this.registeredUsers.size() > 1;
    }
}

