/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard.ldap;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.PasswordAuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.Authenticator;

public class LdapAuthenticator
implements Authenticator {
    private static final String COM_SUN_JNDI_LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final Logger LOG = Logger.getLogger(LdapAuthenticator.class);
    private static final String AUTH_LDAPSERVER_KEY = "nakedobjects.security.ldap.server";
    private static final String AUTH_LDAPDN_KEY = "nakedobjects.security.ldap.dn";
    private static String FILTER = "(objectclass=organizationalRole)";
    private final NakedObjectConfiguration configuration;
    private final String ldapProvider;
    private final String ldapDn;

    public LdapAuthenticator(NakedObjectConfiguration configuration) {
        this.configuration = configuration;
        this.ldapProvider = this.configuration.getString(AUTH_LDAPSERVER_KEY);
        this.ldapDn = this.configuration.getString(AUTH_LDAPDN_KEY);
    }

    public boolean canAuthenticate(AuthenticationRequest request) {
        return request instanceof PasswordAuthenticationRequest;
    }

    private void setRoles(DirContext authContext, AuthenticationRequest request, String username) throws NamingException {
        ArrayList<String> roles = new ArrayList<String>();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"cn"});
        String name = "uid=" + username + ", " + this.ldapDn;
        NamingEnumeration<SearchResult> answer = authContext.search(name, FILTER, controls);
        while (answer.hasMore()) {
            SearchResult result = (SearchResult)answer.nextElement();
            String roleName = (String)result.getAttributes().get("cn").get(0);
            roles.add(roleName);
            LOG.debug((Object)("Adding role: " + roleName));
        }
        request.setRoles(roles.toArray(new String[roles.size()]));
    }

    public boolean isValid(AuthenticationRequest request) {
        PasswordAuthenticationRequest passwordRequest = (PasswordAuthenticationRequest)request;
        String username = passwordRequest.getName();
        Assert.assertNotNull((Object)username);
        if (username.equals("")) {
            LOG.debug((Object)"empty username");
            return false;
        }
        String password = passwordRequest.getPassword();
        Assert.assertNotNull((Object)password);
        Hashtable<String, String> env = new Hashtable<String, String>(4);
        env.put("java.naming.factory.initial", COM_SUN_JNDI_LDAP_CTX_FACTORY);
        env.put("java.naming.provider.url", this.ldapProvider);
        env.put("java.naming.security.principal", "uid=" + username + ", " + this.ldapDn);
        env.put("java.naming.security.credentials", password);
        InitialDirContext authContext = null;
        try {
            authContext = new InitialDirContext(env);
            this.setRoles(authContext, request, username);
            boolean bl = true;
            return bl;
        }
        catch (AuthenticationException e) {
            boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            throw new NakedObjectException("Failed to authenticate using LDAP", (Throwable)e);
        }
        finally {
            try {
                if (authContext != null) {
                    authContext.close();
                }
            }
            catch (NamingException e) {
                throw new NakedObjectException("Failed to authenticate using LDAP", (Throwable)e);
            }
        }
    }
}

