/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authorization.standard.ldap;

import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authorization.standard.Authorizor;

public class LdapAuthorizor
implements Authorizor {
    private static final String FILTER = "(&(uniquemember={0}) (|(cn={1}) (cn={2}) (cn={3})))";
    private static final Logger LOG = Logger.getLogger(LdapAuthorizor.class);
    private static final String COM_SUN_JNDI_LDAP_LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String AUTH_LDAPSERVER_KEY = "nakedobjects.security.ldap.server";
    private static final String AUTH_LDAPDN_KEY = "nakedobjects.security.ldap.dn";
    private static final String AUTH_APPDN_KEY = "nakedobjects.security.ldap.application.dn";
    private static final String AUTH_LEARN_KEY = "nakedobjects.security.learn";
    private static final boolean AUTH_LEARN_DEFAULT = false;
    private final String ldapProvider;
    private final String ldapDn;
    private final String appDn;
    private final boolean learn;
    private final NakedObjectConfiguration configuration;
    private static final String RW = "RW";

    public LdapAuthorizor(NakedObjectConfiguration configuration) {
        this.configuration = configuration;
        this.ldapProvider = this.getConfiguration().getString(AUTH_LDAPSERVER_KEY);
        this.ldapDn = this.getConfiguration().getString(AUTH_LDAPDN_KEY);
        this.appDn = this.getConfiguration().getString(AUTH_APPDN_KEY);
        this.learn = this.getConfiguration().getBoolean(AUTH_LEARN_KEY, false);
    }

    public void init() {
    }

    private boolean isPermitted(DirContext authContext, String role, Identifier member, String flag) throws NamingException {
        String cls = member.toIdentityString(0);
        String name = member.toIdentityString(3);
        String parms = member.toIdentityString(4);
        Object[] args = new Object[]{role, cls, name, parms};
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        String searchName = this.buildSearchName(cls, this.appDn);
        NamingEnumeration<SearchResult> answer = authContext.search(searchName, FILTER, args, controls);
        while (answer.hasMore()) {
            Attribute flagAttribute;
            SearchResult result = (SearchResult)answer.nextElement();
            String cn = (String)result.getAttributes().get("cn").get(0);
            if (!cn.equals(cls) && !cn.equals(name) && (!cn.equals(parms) || !result.getName().contains(name))) continue;
            if (flag != null && (flagAttribute = result.getAttributes().get("flag")) != null) {
                return flag.equalsIgnoreCase((String)flagAttribute.get(0));
            }
            return true;
        }
        return false;
    }

    private String buildSearchName(String cls, String appDn) {
        StringBuffer search = new StringBuffer();
        search.append("cn=").append(cls).append(", ").append(appDn);
        String searchName = search.toString();
        return searchName;
    }

    private Attributes createCommonAttributes(String cnName, String role, boolean isClass) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("javaContainer");
        objclass.add("groupOfUniqueNames");
        if (isClass) {
            objclass.add("javaObject");
        }
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(cnName);
        BasicAttribute uniqueMember = new BasicAttribute("uniquemember");
        uniqueMember.add(role);
        if (isClass) {
            BasicAttribute javaClass = new BasicAttribute("javaclassname");
            javaClass.add(cnName);
            attrs.put(javaClass);
        }
        attrs.put(objclass);
        attrs.put(cn);
        attrs.put(uniqueMember);
        return attrs;
    }

    private String createClassBindname(String cls) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(cls).append(", ").append(this.appDn);
        return bindName.toString();
    }

    private void bindClass(DirContext authContext, String role, Identifier member) throws NamingException {
        String cls = member.toIdentityString(0);
        Attributes attrs = this.createCommonAttributes(cls, role, true);
        try {
            authContext.createSubcontext(this.createClassBindname(cls), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private String createNameBindname(String cls, String name) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(name).append(", ");
        bindName.append(this.createClassBindname(cls));
        return bindName.toString();
    }

    private void bindName(DirContext authContext, String role, Identifier member) throws NamingException {
        String cls = member.toIdentityString(0);
        String name = member.toIdentityString(3);
        Attributes attrs = this.createCommonAttributes(name, role, false);
        try {
            authContext.createSubcontext(this.createNameBindname(cls, name), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private String createParmsBindname(String cls, String name, String parms) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(parms).append(", ");
        bindName.append(this.createNameBindname(cls, name));
        return bindName.toString();
    }

    private void bindParms(DirContext authContext, String role, Identifier member) throws NamingException {
        String cls = member.toIdentityString(0);
        String name = member.toIdentityString(3);
        String parms = member.toIdentityString(4).replace(",", "\\,");
        if (parms.length() == 0) {
            return;
        }
        Attributes attrs = this.createCommonAttributes(parms, role, false);
        try {
            authContext.createSubcontext(this.createParmsBindname(cls, name, parms), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private boolean bindNames(DirContext authContext, String role, Identifier member) throws NamingException {
        this.bindClass(authContext, role, member);
        this.bindName(authContext, role, member);
        this.bindParms(authContext, role, member);
        return true;
    }

    private boolean isAuthorised(String role, Identifier member, String flag) {
        Hashtable<String, String> env = new Hashtable<String, String>(4);
        env.put("java.naming.factory.initial", COM_SUN_JNDI_LDAP_LDAP_CTX_FACTORY);
        env.put("java.naming.provider.url", this.ldapProvider);
        if (this.learn) {
            env.put("java.naming.security.principal", "uid=admin, ou=system");
            env.put("java.naming.security.credentials", "secret");
        }
        InitialDirContext authContext = null;
        try {
            authContext = new InitialDirContext(env);
            if (this.learn) {
                boolean bl = this.bindNames(authContext, role, member);
                return bl;
            }
            boolean bl = this.isPermitted(authContext, role, member, flag);
            return bl;
        }
        catch (AuthenticationException e) {
            throw new NakedObjectException("Failed to authorise using LDAP", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            throw new NakedObjectException("Failed to authorise using LDAP", (Throwable)e);
        }
        finally {
            try {
                if (authContext != null) {
                    authContext.close();
                }
            }
            catch (NamingException e) {
                throw new NakedObjectException("Failed to authorise using LDAP", (Throwable)e);
            }
        }
    }

    public void shutdown() {
    }

    public boolean isUsable(String role, Identifier member) {
        return this.isAuthorised(role, member, RW);
    }

    public boolean isVisible(String role, Identifier member) {
        return this.isAuthorised(role, member, null);
    }

    private NakedObjectConfiguration getConfiguration() {
        return this.configuration;
    }
}

