/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.boot.cmdline;

import org.apache.commons.cli.Options;
import org.apache.log4j.Level;
import org.nakedobjects.runtime.boot.BootSystemParameter;
import org.nakedobjects.runtime.boot.NakedObjectsBootstrapperAbstract;
import org.nakedobjects.runtime.boot.RootLogging;
import org.nakedobjects.runtime.boot.cmdline.internal.ArgumentsOptionsBuilder;
import org.nakedobjects.runtime.boot.cmdline.internal.ArgumentsParser;
import org.nakedobjects.runtime.boot.cmdline.internal.BootPrinter;
import org.nakedobjects.runtime.boot.cmdline.internal.CommandLineValidator;
import org.nakedobjects.runtime.boot.systemfactory.usinginstallers.NakedObjectSystemUsingInstallersFactory;
import org.nakedobjects.runtime.installers.InstallerRepository;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.Splash;
import org.nakedobjects.runtime.system.internal.NakedObjectsLoggingInitializer;

public final class NakedObjectsBootstrapperCmdLine
extends NakedObjectsBootstrapperAbstract {
    private NakedObjectsLoggingInitializer loggingInitializer = new NakedObjectsLoggingInitializer();
    private final CommandLineValidator commandLineValidator;
    private final BootPrinter printer = new BootPrinter();

    public NakedObjectsBootstrapperCmdLine() {
        this(new NakedObjectSystemUsingInstallersFactory());
    }

    protected NakedObjectsBootstrapperCmdLine(NakedObjectSystemUsingInstallersFactory systemFactory) {
        super(systemFactory);
        this.commandLineValidator = new CommandLineValidator();
    }

    public NakedObjectSystemUsingInstallersFactory getSystemFactory() {
        return (NakedObjectSystemUsingInstallersFactory)super.getSystemFactory();
    }

    public void run(String[] args) {
        this.loggingInitializer.configureLogging();
        Level loggingLevel = ArgumentsParser.loggingLevel(args);
        RootLogging.setRootLoggingLevel(loggingLevel);
        this.getSystemFactory().init();
        Options options = this.buildOptions(this.getSystemFactory().getInstallerLookup());
        ArgumentsParser argumentsParser = this.parseArguments(options, args, this.printer);
        if (argumentsParser == null) {
            return;
        }
        DeploymentType deploymentType = argumentsParser.getDeploymentType();
        String connection = argumentsParser.getConnection();
        String objectPersistor = argumentsParser.getObjectPersistor();
        String userProfilePersistor = argumentsParser.getUserProfilePersistor();
        String reflector = argumentsParser.getReflector();
        String user = argumentsParser.getUser();
        String password = argumentsParser.getPassword();
        String config = argumentsParser.getConfig();
        String[] additionalProperties = argumentsParser.getAdditionalProperties();
        String viewer = argumentsParser.getViewer();
        Splash splash = Splash.lookup(argumentsParser.isSplash());
        String fixture = argumentsParser.getFixture();
        if (!this.commandLineValidator.validateCommandLineArgs(options, this.printer, deploymentType, connection, objectPersistor, userProfilePersistor, user, password)) {
            return;
        }
        this.bootSystem(new BootSystemParameter(loggingLevel, deploymentType, connection, reflector, objectPersistor, userProfilePersistor, user, password, config, additionalProperties, viewer, splash, fixture));
    }

    private Options buildOptions(InstallerRepository installerRepository) {
        ArgumentsOptionsBuilder optionsBuilder = new ArgumentsOptionsBuilder(installerRepository);
        Options options = new Options();
        optionsBuilder.addBasicOptions(options);
        optionsBuilder.addComponentOptions(options);
        return options;
    }

    private ArgumentsParser parseArguments(Options options, String[] args, BootPrinter printer) {
        ArgumentsParser argumentsParser = new ArgumentsParser(printer);
        return argumentsParser.parse(options, args) ? argumentsParser : null;
    }
}

