/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.boot.cmdline.internal;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.runtime.boot.cmdline.internal.Arguments;
import org.nakedobjects.runtime.client.NakedObjectClientInstaller;
import org.nakedobjects.runtime.installers.InstallerRepository;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstaller;
import org.nakedobjects.runtime.remoting.ServerListenerInstaller;
import org.nakedobjects.runtime.userprofile.UserProfileStoreInstaller;

public class ArgumentsOptionsBuilder {
    private InstallerRepository installerRepository;

    public ArgumentsOptionsBuilder(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    public void addBasicOptions(Options options) {
        options.addOption("h", "help", false, "show this help");
        options.addOption("s", "nosplash", false, "don't show splash window");
        options.addOption("debug", false, "print debugging messages");
        options.addOption("verbose", false, "print information, warning and error messages");
        options.addOption("quiet", false, "print error messages only");
        options.addOption("diagnostics", false, "print information that can be used diagnose or report problems");
        options.addOption("version", false, "print version information");
    }

    public void addComponentOptions(Options options) {
        OptionBuilder.withArgName((String)"config file");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"read in configuration file (as well as nakedobjects.properties)");
        Option option = OptionBuilder.create((String)"c");
        options.addOption(option);
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.withDescription((String)("type of system: " + Arguments.TYPE_EXPLORATION + "; " + Arguments.TYPE_PROTOTYPE + " (default); " + Arguments.TYPE_STANDALONE + "; " + Arguments.TYPE_CLIENT + "; " + Arguments.TYPE_SERVER_EXPLORATION + "; " + Arguments.TYPE_SERVER_PROTOTYPE + "; " + Arguments.TYPE_SERVER));
        option = OptionBuilder.create((String)"t");
        options.addOption(option);
        OptionBuilder.withArgName((String)"user name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"user");
        OptionBuilder.withDescription((String)"user name to log in with");
        option = OptionBuilder.create((String)"u");
        options.addOption(option);
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.withDescription((String)"password to automatically log in with");
        option = OptionBuilder.create((String)"p");
        options.addOption(option);
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"fixture");
        OptionBuilder.withDescription((String)"fully qualified fixture class");
        option = OptionBuilder.create((String)"f");
        options.addOption(option);
        Object[] objectPersistenceMechanisms = this.installerRepository.getInstallers(PersistenceMechanismInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"persistence");
        OptionBuilder.withDescription((String)("object persistence mechanism to use (ignored if type is prototype or client): " + this.availableComponents(objectPersistenceMechanisms) + "; or class name"));
        option = OptionBuilder.create((String)"r");
        options.addOption(option);
        Object[] persistenceMechanisms = this.installerRepository.getInstallers(UserProfileStoreInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"profiles");
        OptionBuilder.withDescription((String)("user profile persistence mechanism to use: " + this.availableComponents(persistenceMechanisms) + "; or class name"));
        option = OptionBuilder.create((String)"o");
        options.addOption(option);
        Object[] reflectors = this.installerRepository.getInstallers(NakedObjectReflectorInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"reflector");
        OptionBuilder.withDescription((String)("reflector to use (ignored if type is prototype or client): " + this.availableComponents(reflectors) + "; or class name"));
        option = OptionBuilder.create((String)"l");
        options.addOption(option);
        Object[] viewers = this.installerRepository.getInstallers(NakedObjectClientInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"viewer");
        OptionBuilder.withDescription((String)("viewer to use (ignored if type is server): " + this.availableComponents(viewers) + "; or class name"));
        option = OptionBuilder.create((String)"v");
        options.addOption(option);
        Object[] connections = this.installerRepository.getInstallers(ServerListenerInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"connection");
        OptionBuilder.withDescription((String)("connection to use for client requests, or server to listen on: " + this.availableComponents(connections)));
        option = OptionBuilder.create((String)"x");
        options.addOption(option);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((String)"D");
        property.setArgs(-2);
        options.addOption(property);
    }

    StringBuffer availableComponents(Object[] factories) {
        StringBuffer types = new StringBuffer();
        for (int i = 0; i < factories.length; ++i) {
            if (i > 0) {
                types.append("; ");
            }
            types.append(((Installer)factories[i]).getName());
        }
        return types;
    }
}

