/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.boot.cmdline.internal;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.nakedobjects.runtime.boot.cmdline.internal.Arguments;
import org.nakedobjects.runtime.boot.cmdline.internal.BootPrinter;
import org.nakedobjects.runtime.system.DeploymentType;

public class ArgumentsParser {
    private BootPrinter printer;
    private CommandLine cmd;

    public ArgumentsParser(BootPrinter printer) {
        this.printer = printer;
    }

    public static Level loggingLevel(String[] args) {
        Level level = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-debug")) {
                level = Level.DEBUG;
                break;
            }
            if (args[i].equals("-quiet")) {
                level = Level.ERROR;
                break;
            }
            if (!args[i].equals("-verbose")) continue;
            level = Level.INFO;
            break;
        }
        return level;
    }

    public boolean parse(Options options, String[] args) {
        BasicParser parser = new BasicParser();
        this.cmd = null;
        try {
            this.cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printer.printErrorMessage(e.getMessage());
            this.printer.printHelp(options);
            return false;
        }
        if (this.cmd.hasOption("h")) {
            this.printer.printHelp(options);
            return false;
        }
        if (this.cmd.hasOption("version")) {
            this.printer.printVersion();
            return false;
        }
        if (this.cmd.hasOption("diagnostics")) {
            this.printer.printDiagnostics();
            return false;
        }
        return true;
    }

    private String getDeploymentTypeName() {
        this.ensureParsed();
        String modeName = this.cmd.getOptionValue("t");
        return modeName == null ? Arguments.TYPE_PROTOTYPE : modeName.toLowerCase();
    }

    public DeploymentType getDeploymentType() {
        DeploymentType valueOf = DeploymentType.valueOf(this.getDeploymentTypeName().toUpperCase());
        if (valueOf != null) {
            return valueOf;
        }
        throw new IllegalStateException("Unable to determine deployment type");
    }

    public String getConnection() {
        return this.cmd.getOptionValue("x");
    }

    public String getProgModel() {
        return this.cmd.getOptionValue("m");
    }

    public String getConfig() {
        return this.cmd.getOptionValue("c");
    }

    public String getObjectPersistor() {
        this.ensureParsed();
        return this.cmd.getOptionValue("r");
    }

    public String getUserProfilePersistor() {
        this.ensureParsed();
        return this.cmd.getOptionValue("o");
    }

    public String getReflector() {
        this.ensureParsed();
        return this.cmd.getOptionValue("l");
    }

    public String getUser() {
        this.ensureParsed();
        return this.cmd.getOptionValue("u");
    }

    public String getPassword() {
        this.ensureParsed();
        return this.cmd.getOptionValue("p");
    }

    public String getViewer() {
        this.ensureParsed();
        return this.cmd.getOptionValue("v");
    }

    public String getFixture() {
        this.ensureParsed();
        return this.cmd.getOptionValue("f");
    }

    public boolean isSplash() {
        this.ensureParsed();
        boolean noSplash = this.cmd.hasOption('s');
        return !noSplash;
    }

    public String[] getAdditionalProperties() {
        this.ensureParsed();
        return this.cmd.getOptionValues("D");
    }

    private void ensureParsed() {
        if (this.cmd == null) {
            throw new IllegalStateException("Call parse() first");
        }
    }
}

