/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.context;

import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugList;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectsContext
implements DebugInfo {
    private static final Logger LOG = Logger.getLogger(NakedObjectsContext.class);
    private static NakedObjectsContext singleton;
    private final NakedObjectSessionFactory sessionFactory;
    private final ContextReplacePolicy replacePolicy;
    private final SessionClosePolicy sessionClosePolicy;
    private static NakedObjectConfiguration configuration;

    public static NakedObjectsContext getInstance() {
        return singleton;
    }

    public static boolean exists() {
        return singleton != null;
    }

    public static void testReset() {
        singleton = null;
    }

    protected NakedObjectsContext(ContextReplacePolicy replacePolicy, SessionClosePolicy sessionClosePolicy, NakedObjectSessionFactory sessionFactory) {
        if (singleton != null && !singleton.isContextReplaceable()) {
            throw new NakedObjectException("Naked Objects Context already set up and cannot be replaced");
        }
        singleton = this;
        this.sessionFactory = sessionFactory;
        this.sessionClosePolicy = sessionClosePolicy;
        this.replacePolicy = replacePolicy;
    }

    public final NakedObjectSessionFactory getSessionFactoryInstance() {
        return this.sessionFactory;
    }

    public final boolean isContextReplaceable() {
        return this.replacePolicy == ContextReplacePolicy.REPLACEABLE;
    }

    public final boolean isSessionAutocloseable() {
        return this.sessionClosePolicy == SessionClosePolicy.AUTO_CLOSE;
    }

    protected void applySessionClosePolicy() {
        if (this.getSessionInstance() == null) {
            return;
        }
        if (!this.isSessionAutocloseable()) {
            throw new IllegalStateException("Session already open and context not configured for autoclose");
        }
        this.closeSessionInstance();
    }

    public abstract NakedObjectSession openSessionInstance(AuthenticationSession var1);

    public final void closeSessionInstance() {
        if (this.getSessionInstance() != null) {
            this.getSessionInstance().close();
            this.doClose();
        }
    }

    protected void doClose() {
    }

    protected abstract void closeAllSessionsInstance();

    public abstract NakedObjectSession getSessionInstance();

    protected abstract NakedObjectSession getSessionInstance(String var1);

    public abstract String[] allSessionIds();

    public static NakedObjectSession openSession(AuthenticationSession authenticationSession) {
        return NakedObjectsContext.getInstance().openSessionInstance(authenticationSession);
    }

    public static void closeSession() {
        NakedObjectsContext.getInstance().closeSessionInstance();
    }

    public static NakedObjectSession getSession(String sessionId) {
        return NakedObjectsContext.getInstance().getSessionInstance(sessionId);
    }

    public static void closeAllSessions() {
        LOG.info((Object)"closing all instances");
        NakedObjectsContext instance = NakedObjectsContext.getInstance();
        if (instance != null) {
            instance.closeAllSessionsInstance();
        }
    }

    public static NakedObjectSessionFactory getSessionFactory() {
        return NakedObjectsContext.getInstance().getSessionFactoryInstance();
    }

    public static NakedObjectConfiguration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(NakedObjectConfiguration configuration) {
        NakedObjectsContext.configuration = configuration;
    }

    public static DeploymentType getDeploymentType() {
        return NakedObjectsContext.getSessionFactory().getDeploymentType();
    }

    public static SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSessionFactory().getSpecificationLoader();
    }

    public static AuthenticationManager getAuthenticationManager() {
        return NakedObjectsContext.getSessionFactory().getAuthenticationManager();
    }

    public static TemplateImageLoader getTemplateImageLoader() {
        return NakedObjectsContext.getSessionFactory().getTemplateImageLoader();
    }

    public static UserProfileLoader getUserProfileLoader() {
        return NakedObjectsContext.getSessionFactory().getUserProfileLoader();
    }

    public static List<Object> getServices() {
        return NakedObjectsContext.getSessionFactory().getServices();
    }

    public static boolean inSession() {
        NakedObjectSession session = NakedObjectsContext.getInstance().getSessionInstance();
        return session != null;
    }

    public static NakedObjectSession getSession() {
        NakedObjectSession session = NakedObjectsContext.getInstance().getSessionInstance();
        if (session == null) {
            throw new IllegalStateException("No Session opened for this thread");
        }
        return session;
    }

    public static String getSessionId() {
        return NakedObjectsContext.getSession().getId();
    }

    public static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getSession().getAuthenticationSession();
    }

    public static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getSession().getPersistenceSession();
    }

    public static UserProfile getUserProfile() {
        return NakedObjectsContext.getSession().getUserProfile();
    }

    public static NakedObjectTransactionManager getTransactionManager() {
        return NakedObjectsContext.getPersistenceSession().getTransactionManager();
    }

    public static boolean inTransaction() {
        return NakedObjectsContext.inSession() && NakedObjectsContext.getCurrentTransaction() != null && !NakedObjectsContext.getCurrentTransaction().getState().isComplete();
    }

    public static NakedObjectTransaction getCurrentTransaction() {
        return NakedObjectsContext.getSession().getCurrentTransaction();
    }

    public static MessageBroker getMessageBroker() {
        return NakedObjectsContext.getCurrentTransaction().getMessageBroker();
    }

    public static UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getCurrentTransaction().getUpdateNotifier();
    }

    public static DebugInfo[] debugSystem() {
        DebugList debugList = new DebugList("Naked Objects System");
        debugList.add("Context", (Object)NakedObjectsContext.getInstance());
        debugList.add("Naked Objects session factory", (Object)NakedObjectsContext.getSessionFactory());
        debugList.add("  Authentication manager", (Object)NakedObjectsContext.getSessionFactory().getAuthenticationManager());
        debugList.add("  Persistence session factory", (Object)NakedObjectsContext.getSessionFactory().getPersistenceSessionFactory());
        debugList.add("User profile loader", (Object)NakedObjectsContext.getUserProfileLoader());
        debugList.add("Reflector", (Object)NakedObjectsContext.getSpecificationLoader());
        debugList.add("Template image loader", (Object)NakedObjectsContext.getTemplateImageLoader());
        debugList.add("Deployment type", (Object)NakedObjectsContext.getDeploymentType());
        debugList.add("Configuration", (Object)NakedObjectsContext.getConfiguration());
        debugList.add("Services", NakedObjectsContext.getServices());
        return debugList.debug();
    }

    public static DebugInfo[] debugSession() {
        DebugList debugList = new DebugList("Naked Objects Session");
        debugList.add("Naked Objects session", (Object)NakedObjectsContext.getSession());
        debugList.add("Authentication session", (Object)NakedObjectsContext.getAuthenticationSession());
        debugList.add("User profile", (Object)NakedObjectsContext.getUserProfile());
        debugList.add("Persistence Session", (Object)NakedObjectsContext.getPersistenceSession());
        debugList.add("Transaction Manager", (Object)NakedObjectsContext.getTransactionManager());
        debugList.add("Service injector", (Object)NakedObjectsContext.getPersistenceSession().getServicesInjector());
        debugList.add("Adapter factory", NakedObjectsContext.getPersistenceSession().getAdapterFactory());
        debugList.add("Object factory", (Object)NakedObjectsContext.getPersistenceSession().getObjectFactory());
        debugList.add("OID generator", NakedObjectsContext.getPersistenceSession().getOidGenerator());
        debugList.add("Adapter manager", (Object)NakedObjectsContext.getPersistenceSession().getAdapterManager());
        debugList.add("Services", NakedObjectsContext.getPersistenceSession().getServices());
        return debugList.debug();
    }

    public void debugData(DebugString debug) {
        debug.appendln("context ", (Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ContextReplacePolicy {
        NOT_REPLACEABLE,
        REPLACEABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SessionClosePolicy {
        EXPLICIT_CLOSE,
        AUTO_CLOSE;

    }
}

