/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.i18n.resourcebundle;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.help.HelpFacet;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.spec.identifier.Identified;
import org.nakedobjects.runtime.i18n.resourcebundle.I18nManager;
import org.nakedobjects.runtime.i18n.resourcebundle.facets.DescribedAsFacetWrapI18n;
import org.nakedobjects.runtime.i18n.resourcebundle.facets.HelpFacetWrapI18n;
import org.nakedobjects.runtime.i18n.resourcebundle.facets.NamedFacetWrapI18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nFacetDecorator
extends FacetDecoratorAbstract {
    private final I18nManager i18nManager;

    public I18nFacetDecorator(I18nManager manager) {
        this.i18nManager = manager;
    }

    public Facet decorate(Facet facet, FacetHolder holder) {
        if (!(holder instanceof Identified)) {
            return null;
        }
        Identified identified = (Identified)holder;
        Identifier identifier = identified.getIdentifier();
        Class facetType = facet.facetType();
        if (facetType == NamedFacet.class) {
            String i18nName = this.i18nManager.getName(identifier);
            if (i18nName == null) {
                return null;
            }
            return new NamedFacetWrapI18n(i18nName, facet.getFacetHolder());
        }
        if (facetType == DescribedAsFacet.class) {
            String i18nDescription = this.i18nManager.getDescription(identifier);
            if (i18nDescription == null) {
                return null;
            }
            return new DescribedAsFacetWrapI18n(i18nDescription, facet.getFacetHolder());
        }
        if (facetType == HelpFacet.class) {
            String i18nHelp = this.i18nManager.getHelp(identifier);
            if (i18nHelp == null) {
                return null;
            }
            return new HelpFacetWrapI18n(i18nHelp, facet.getFacetHolder());
        }
        return facet;
    }

    public Class<? extends Facet>[] forFacetTypes() {
        return new Class[]{NamedFacet.class, DescribedAsFacet.class, HelpFacet.class};
    }
}

