/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.i18n.resourcebundle;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.i18n.resourcebundle.I18nManager;

public class ResourceBasedI18nManager
implements I18nManager {
    private static final Logger LOG = Logger.getLogger(ResourceBasedI18nManager.class);
    private static final String BASE_FILE_NAME = "i18n";
    private static final String PARAMETER = "parameter";
    private static final String DESCRIPTION = "description";
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String HELP = "help";
    private static final String ACTION = "action";
    private ResourceBundle bundle;
    private NakedObjectConfiguration configuration;

    public ResourceBasedI18nManager(NakedObjectConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        try {
            this.bundle = ResourceBundle.getBundle(BASE_FILE_NAME);
        }
        catch (MissingResourceException e) {
            LOG.warn((Object)("Missing resource bundle: " + e.getMessage()));
        }
    }

    public void shutdown() {
    }

    public String getName(Identifier identifier) {
        return this.text(identifier, NAME);
    }

    public String getDescription(Identifier identifier) {
        return this.text(identifier, DESCRIPTION);
    }

    public String getHelp(Identifier identifier) {
        return this.text(identifier, HELP);
    }

    public String[] getParameterNames(Identifier identifier) {
        if (this.bundle == null) {
            return null;
        }
        String[] array = new String[identifier.getMemberParameterNames().length];
        for (int i = 0; i < array.length; ++i) {
            String key = identifier.getClassName() + "." + ACTION + "." + identifier.getMemberName() + "." + PARAMETER + (i + 1) + "." + NAME;
            try {
                array[i] = this.bundle.getString(key);
                continue;
            }
            catch (MissingResourceException e) {
                array[i] = null;
            }
        }
        return array;
    }

    private String text(Identifier identifier, String type) {
        if (this.bundle == null) {
            return null;
        }
        String form = identifier.isPropertyOrCollection() ? PROPERTY : ACTION;
        String key = identifier.getClassName() + "." + form + "." + identifier.getMemberName() + "." + type;
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

