/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.imageloader.awt;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.Resources;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.imageloader.TemplateImage;
import org.nakedobjects.runtime.imageloader.TemplateImageImpl;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateImageLoaderAwt
implements TemplateImageLoader {
    private static final String LOAD_IMAGES_FROM_FILES_KEY = "nakedobjects.images.load-images-from-files";
    private static final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg"};
    private static final Logger LOG = Logger.getLogger(TemplateImageLoaderAwt.class);
    private static final String IMAGE_DIRECTORY = "images";
    private static final String IMAGE_DIRECTORY_PARAM = "nakedobjects.images.image-directory";
    private static final String SEPARATOR = "/";
    private boolean initialized;
    private boolean alsoLoadAsFiles;
    protected final MediaTracker mt = new MediaTracker(new Canvas());
    private final Hashtable<String, TemplateImage> loadedImages = new Hashtable();
    private final Vector<String> missingImages = new Vector();
    private final NakedObjectConfiguration configuration;
    private String directory;

    public TemplateImageLoaderAwt(NakedObjectConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        this.ensureNotInitialized();
        LOG.info((Object)("images to be loaded from " + this.directory()));
        this.alsoLoadAsFiles = this.getConfiguration().getBoolean(LOAD_IMAGES_FROM_FILES_KEY, true);
        this.initialized = true;
    }

    public void shutdown() {
    }

    private void ensureNotInitialized() {
        Ensure.ensureThatState((Object)this.initialized, (Matcher)CoreMatchers.is((Object)false));
    }

    private void ensureInitialized() {
        Ensure.ensureThatState((Object)this.initialized, (Matcher)CoreMatchers.is((Object)true));
    }

    @Override
    public TemplateImage getTemplateImage(String name) {
        this.ensureInitialized();
        if (this.loadedImages.contains(name)) {
            return this.loadedImages.get(name);
        }
        if (this.missingImages.contains(name)) {
            return null;
        }
        List<String> candidates = this.getCandidates(name);
        for (String candidate : candidates) {
            Image image = this.load(candidate);
            TemplateImageImpl templateImage = TemplateImageImpl.create(image);
            if (templateImage == null) continue;
            this.loadedImages.put(name, templateImage);
            return templateImage;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("failed to find image for " + name));
        }
        this.missingImages.addElement(name);
        return null;
    }

    private List<String> getCandidates(String name) {
        boolean hasExtension = false;
        for (String extension : EXTENSIONS) {
            hasExtension = hasExtension || name.endsWith(extension);
        }
        ArrayList<String> candidates = new ArrayList<String>();
        if (hasExtension) {
            candidates.add(name);
        } else {
            for (String extension : EXTENSIONS) {
                candidates.add(name + "." + extension);
            }
        }
        return candidates;
    }

    private Image load(String name) {
        Image image;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("searching for image " + name));
        }
        if ((image = this.loadAsResource(name)) != null) {
            return image;
        }
        String path = this.directory() + name;
        image = this.loadAsResource(path);
        if (image != null) {
            return image;
        }
        if (this.alsoLoadAsFiles && (image = this.loadAsFile(path)) != null) {
            return image;
        }
        return null;
    }

    protected Image loadAsResource(String path) {
        URL url = Resources.getResourceURL((String)path);
        if (url == null) {
            LOG.debug((Object)("not found image in resources: " + url));
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (image != null) {
            this.mt.addImage(image, 0);
            try {
                this.mt.waitForAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mt.isErrorAny()) {
                LOG.error((Object)("found image but failed to load it from resources: " + url + " " + this.mt.getErrorsAny()[0]));
                this.mt.removeImage(image);
                image = null;
            } else {
                this.mt.removeImage(image);
                LOG.info((Object)("image loaded from resources: " + url));
            }
        }
        if (image == null || image.getWidth(null) == -1) {
            throw new RuntimeException(image.toString());
        }
        return image;
    }

    private Image loadAsFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        Toolkit t = Toolkit.getDefaultToolkit();
        Image image = t.getImage(file.getAbsolutePath());
        if (image != null) {
            this.mt.addImage(image, 0);
            try {
                this.mt.waitForAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mt.isErrorAny()) {
                LOG.error((Object)("found image file but failed to load it: " + file.getAbsolutePath()));
                this.mt.removeImage(image);
                image = null;
            } else {
                this.mt.removeImage(image);
                LOG.info((Object)("image loaded from file: " + file));
            }
        }
        return image;
    }

    private String directory() {
        if (this.directory == null) {
            this.directory = this.getConfiguration().getString(IMAGE_DIRECTORY_PARAM, IMAGE_DIRECTORY);
            if (!this.directory.endsWith(SEPARATOR)) {
                this.directory = this.directory.concat(SEPARATOR);
            }
        }
        return this.directory;
    }

    private Image createImage() {
        byte[] pixels = new byte[16384];
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (byte)(i % 128);
        }
        byte[] r = new byte[]{0, 127};
        byte[] g = new byte[]{0, 127};
        byte[] b = new byte[]{0, 127};
        IndexColorModel colorModel = new IndexColorModel(1, 2, r, g, b);
        MemoryImageSource producer = new MemoryImageSource(128, 128, (ColorModel)colorModel, pixels, 0, 128);
        Image image = Toolkit.getDefaultToolkit().createImage(producer);
        return image;
    }

    private NakedObjectConfiguration getConfiguration() {
        return this.configuration;
    }
}

