/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.installers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationException;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.commons.factory.UnavailableClassException;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoader;
import org.nakedobjects.metamodel.config.loader.NotFoundPolicy;
import org.nakedobjects.metamodel.config.provider.NakedObjectConfigurationProvider;
import org.nakedobjects.metamodel.config.provider.NakedObjectConfigurationProviderAware;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.runtime.authentication.AuthenticationManagerInstaller;
import org.nakedobjects.runtime.authorization.AuthorizationFacetDecoratorInstaller;
import org.nakedobjects.runtime.client.NakedObjectClientInstaller;
import org.nakedobjects.runtime.fixturesinstaller.FixturesInstaller;
import org.nakedobjects.runtime.imageloader.TemplateImageLoaderInstaller;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupAware;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstaller;
import org.nakedobjects.runtime.persistence.services.ServicesInstaller;
import org.nakedobjects.runtime.remoting.ClientConnectionInstaller;
import org.nakedobjects.runtime.remoting.ServerListenerInstaller;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.userprofile.UserProfileStoreInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerLookupImpl
implements InstallerLookup {
    private static final Logger LOG = Logger.getLogger(InstallerLookupImpl.class);
    public final String INSTALLER_REGISTRY_FILE = "installer-registry.properties";
    private List<Installer> installerList;
    private ConfigurationLoader configurationLoader;
    private NakedObjectConfiguration cachedConfiguration;
    private final Class<?> cls;

    public InstallerLookupImpl(Class<?> cls) {
        this.cls = cls;
    }

    /*
     * Exception decompiling
     */
    public void loadInstallers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public AuthenticationManagerInstaller authenticatorInstaller(String requested) {
        return this.getInstaller(AuthenticationManagerInstaller.class, requested, "nakedobjects.component.authentication", "file");
    }

    @Override
    public AuthorizationFacetDecoratorInstaller authorisationInstaller(String requested) {
        return this.getInstaller(AuthorizationFacetDecoratorInstaller.class, requested, "nakedobjects.component.authorisation", "file");
    }

    @Override
    public FixturesInstaller fixturesInstaller(String requested) {
        return this.getInstaller(FixturesInstaller.class, requested, "nakedobjects.component.fixtures", "configuration");
    }

    @Override
    public TemplateImageLoaderInstaller templateImageLoaderInstaller(String requested) {
        return this.getInstaller(TemplateImageLoaderInstaller.class, requested, "nakedobjects.component.image-loader", "awt");
    }

    @Override
    public PersistenceMechanismInstaller persistenceMechanismInstaller(String requested, DeploymentType deploymentType) {
        String persistorDefault = deploymentType.isExploring() || deploymentType.isPrototyping() ? "in-memory" : "xml";
        return this.getInstaller(PersistenceMechanismInstaller.class, requested, "nakedobjects.component.persistor", persistorDefault);
    }

    @Override
    public UserProfileStoreInstaller userProfilePersistenceMechanismInstaller(String requested, DeploymentType deploymentType) {
        String persistorDefault = deploymentType.isExploring() || deploymentType.isPrototyping() ? "in-memory" : "xml";
        return this.getInstaller(UserProfileStoreInstaller.class, requested, "nakedobjects.component.user-profile-persistor", persistorDefault);
    }

    @Override
    public NakedObjectReflectorInstaller reflectorInstaller(String requested) {
        return this.getInstaller(NakedObjectReflectorInstaller.class, requested, "nakedobjects.component.reflector", "java");
    }

    @Override
    public ClientConnectionInstaller clientConnectionInstaller(String requested) {
        ClientConnectionInstaller installer = this.getInstaller(ClientConnectionInstaller.class, requested, "nakedobjects.component.client-connection", "xstream");
        if (installer != null) {
            Properties properties = installer.getRemoteProperties();
            this.configurationLoader.add(properties);
        }
        return installer;
    }

    @Override
    public ServerListenerInstaller listenerInstaller(String name) {
        if (name == null) {
            throw new NakedObjectException("No server listener specified");
        }
        ServerListenerInstaller component = this.getInstaller(ServerListenerInstaller.class, name);
        if (component == null) {
            throw new NakedObjectException("No server listener of type " + name);
        }
        return component;
    }

    @Override
    public ServicesInstaller servicesInstaller(String requestedImplementationName) {
        return this.getInstaller(ServicesInstaller.class, requestedImplementationName, "nakedobjects.component.services", "configuration");
    }

    @Override
    public NakedObjectClientInstaller clientInstaller(String name, String defaultName) {
        String viewer = name == null ? this.getConfiguration().getString("nakedobjects.component.viewer", defaultName) : name;
        if (viewer == null) {
            return null;
        }
        return this.getInstaller(NakedObjectClientInstaller.class, viewer);
    }

    @Override
    public <T extends Installer> T getInstaller(Class<T> cls, String implName) {
        if (implName == null) {
            throw new IllegalArgumentException("No name specified");
        }
        for (Installer installer : this.installerList) {
            if (!cls.isAssignableFrom(installer.getClass()) || !installer.getName().equals(implName)) continue;
            this.mergeConfigurationFor(installer);
            this.configure(installer);
            return (T)installer;
        }
        return (T)this.getInstaller(implName);
    }

    public Installer getInstaller(String implClassName) {
        try {
            Installer installer = (Installer)CastUtils.cast((Object)InstanceFactory.createInstance((String)implClassName));
            if (installer != null) {
                this.mergeConfigurationFor(installer);
                this.configure(installer);
            }
            return installer;
        }
        catch (InstanceCreationException e) {
            throw new InstanceCreationException("Specification error in installer-registry.properties", (Throwable)e);
        }
        catch (UnavailableClassException e) {
            return null;
        }
    }

    @Override
    public <T extends Installer> T getInstaller(Class<T> installerCls) {
        try {
            Installer installer = (Installer)InstanceFactory.createInstance(installerCls);
            if (installer != null) {
                this.mergeConfigurationFor(installer);
                this.configure(installer);
            }
            return (T)installer;
        }
        catch (InstanceCreationException e) {
            throw new InstanceCreationException("Specification error in installer-registry.properties", (Throwable)e);
        }
        catch (UnavailableClassException e) {
            return null;
        }
    }

    @Override
    public Installer[] getInstallers(Class<?> cls) {
        ArrayList<Installer> list = new ArrayList<Installer>();
        for (Installer comp : this.installerList) {
            if (!cls.isAssignableFrom(comp.getClass())) continue;
            list.add(comp);
        }
        return list.toArray(new Installer[list.size()]);
    }

    private <T extends Installer> T getInstaller(Class<T> requiredType, String reqImpl, String key, String defaultImpl) {
        T installer;
        if (reqImpl == null) {
            reqImpl = this.getConfiguration().getString(key, defaultImpl);
        }
        if ((installer = this.getInstaller(requiredType, reqImpl)) == null) {
            throw new InstanceCreationException("Failed to load installer class " + reqImpl + " (of type " + requiredType.getName());
        }
        return installer;
    }

    private void close(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new NakedObjectException((Throwable)e);
            }
        }
    }

    private InputStream getInstallerRegistryStream(String componentFile, Class<?> cls) {
        InputStream in = cls.getResourceAsStream("/" + componentFile);
        if (in == null) {
            throw new NakedObjectException("No resource found: " + componentFile);
        }
        return in;
    }

    public void injectInto(Object candidate) {
        if (NakedObjectConfigurationProviderAware.class.isAssignableFrom(candidate.getClass())) {
            NakedObjectConfigurationProviderAware cast = (NakedObjectConfigurationProviderAware)NakedObjectConfigurationProviderAware.class.cast(candidate);
            cast.setConfigurationProvider((NakedObjectConfigurationProvider)this);
        }
    }

    @Override
    public void setConfigurationLoader(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    @Override
    public NakedObjectConfiguration getConfiguration() {
        if (this.cachedConfiguration == null) {
            this.cachedConfiguration = this.configurationLoader.load();
        }
        return this.cachedConfiguration;
    }

    public <T> T configure(T candidate) {
        if (candidate instanceof NakedObjectConfigurationProviderAware) {
            NakedObjectConfigurationProviderAware providerAware = (NakedObjectConfigurationProviderAware)candidate;
            providerAware.setConfigurationProvider((NakedObjectConfigurationProvider)this);
        }
        if (candidate instanceof InstallerLookupAware) {
            InstallerLookupAware installerLookupAware = (InstallerLookupAware)candidate;
            installerLookupAware.setInstallerLookup(this);
        }
        return candidate;
    }

    public void mergeConfigurationFor(Installer installer) {
        if (installer != null) {
            this.configurationLoader.addConfigurationFile(installer.getName() + ".properties", NotFoundPolicy.CONTINUE);
        }
        this.cachedConfiguration = null;
    }
}

