/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import java.io.Serializable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;

class Data
implements Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String resolveState;
    private final Oid oid;

    public Data(Oid oid, String resolveState, String className) {
        this.oid = oid;
        this.className = className;
        this.resolveState = resolveState;
    }

    public Data(ByteDecoder decoder) {
        this.className = decoder.getString();
        this.resolveState = decoder.getString();
        this.oid = (Oid)decoder.getObject();
    }

    public String toString() {
        return this.className + "/" + this.oid;
    }

    public Oid getOid() {
        return this.oid;
    }

    public String getClassName() {
        return this.className;
    }

    public String getResolveState() {
        return this.resolveState;
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.className);
        encoder.add(this.resolveState);
        encoder.add((Object)this.oid);
    }

    public void debug(DebugString debug) {
        debug.appendln(this.className);
        debug.appendln(this.oid != null ? this.oid.toString() : "null");
        debug.appendln(this.resolveState);
    }
}

