/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.memento.CollectionData;
import org.nakedobjects.runtime.memento.Data;
import org.nakedobjects.runtime.memento.ObjectData;
import org.nakedobjects.runtime.memento.StandaloneData;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.PersistorUtil;

public class Memento {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Memento.class);
    private Data state;

    public Memento(NakedObject object) {
        this.state = object == null ? null : this.createData(object);
        LOG.debug((Object)("created memento for " + this));
    }

    private Data createData(NakedObject object) {
        if (object.getSpecification().isCollection()) {
            return this.createCollectionData(object);
        }
        return this.createObjectData(object);
    }

    private Data createCollectionData(NakedObject object) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)object);
        Data[] collData = new Data[facet.size(object)];
        Iterator elements = facet.iterator(object);
        int i = 0;
        while (elements.hasNext()) {
            NakedObject ref = (NakedObject)elements.next();
            collData[i++] = new Data(ref.getOid(), ref.getResolveState().name(), ref.getSpecification().getFullName());
        }
        String elementType = object.getSpecification().getFullName();
        return new CollectionData(object.getOid(), object.getResolveState(), elementType, collData);
    }

    private ObjectData createObjectData(NakedObject adapter) {
        NakedObjectSpecification cls = adapter.getSpecification();
        NakedObjectAssociation[] fields = cls.getAssociations();
        ObjectData data = new ObjectData(adapter.getOid(), adapter.getResolveState().name(), cls.getFullName());
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isPersisted()) continue;
            this.createFieldData(adapter, data, fields[i]);
        }
        return data;
    }

    private void createFieldData(NakedObject object, ObjectData data, NakedObjectAssociation field) {
        Object fieldData;
        if (field.isOneToManyAssociation()) {
            NakedObject coll = field.get(object);
            fieldData = this.createCollectionData(coll);
        } else if (field.getSpecification().isEncodeable()) {
            EncodeableFacet facet = (EncodeableFacet)field.getSpecification().getFacet(EncodeableFacet.class);
            NakedObject value = field.get(object);
            fieldData = facet.toEncodedString(value);
        } else if (field.isOneToOneAssociation()) {
            NakedObject ref = ((OneToOneAssociation)field).get(object);
            fieldData = this.createReferenceData(ref);
        } else {
            throw new UnknownTypeException((Object)field);
        }
        data.addField(field.getId(), fieldData);
    }

    private Data createReferenceData(NakedObject ref) {
        if (ref == null) {
            return null;
        }
        Oid refOid = ref.getOid();
        if (refOid == null) {
            return this.createStandaloneData(ref);
        }
        if (refOid.isTransient()) {
            return this.createObjectData(ref);
        }
        String resolvedState = ref.getResolveState().name();
        String specification = ref.getSpecification().getFullName();
        return new Data(refOid, resolvedState, specification);
    }

    private Data createStandaloneData(NakedObject adapter) {
        return new StandaloneData(adapter);
    }

    public Oid getOid() {
        return this.state.getOid();
    }

    public NakedObject recreateObject() {
        ResolveState targetState;
        NakedObject object;
        if (this.state == null) {
            return null;
        }
        NakedObjectSpecification spec = Memento.getSpecificationLoader().loadSpecification(this.state.getClassName());
        if (this.getOid().isTransient()) {
            object = Memento.getHydrator().recreateAdapter(this.getOid(), spec);
            targetState = ResolveState.SERIALIZING_TRANSIENT;
        } else {
            object = Memento.getHydrator().recreateAdapter(this.getOid(), spec);
            targetState = ResolveState.UPDATING;
        }
        if (object.getSpecification().isCollection()) {
            this.populateCollection(object, (CollectionData)this.state, targetState);
        } else {
            this.updateObject(object, this.state, targetState);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("recreated object " + object.getOid()));
        }
        return object;
    }

    private void populateCollection(NakedObject collection, CollectionData state, ResolveState targetState) {
        NakedObject[] initData = new NakedObject[state.elements.length];
        int i = 0;
        for (Data elementData : state.elements) {
            initData[i++] = this.recreateReference(elementData);
        }
        CollectionFacet facet = (CollectionFacet)collection.getSpecification().getFacet(CollectionFacet.class);
        facet.init(collection, initData);
    }

    private NakedObject recreateReference(Data data) {
        ResolveState resolveState;
        NakedObject ref;
        NakedObjectSpecification spec = Memento.getSpecificationLoader().loadSpecification(data.getClassName());
        if (data instanceof StandaloneData) {
            StandaloneData standaloneData = (StandaloneData)data;
            return standaloneData.getAdapter();
        }
        Oid oid = data.getOid();
        if (oid == null) {
            return null;
        }
        if (oid.isTransient()) {
            ref = Memento.getHydrator().recreateAdapter(oid, spec);
            resolveState = ResolveState.getResolveState((String)data.getResolveState());
        } else {
            ref = Memento.getHydrator().recreateAdapter(oid, spec);
            resolveState = ResolveState.GHOST;
            if (ref.getResolveState().isValidToChangeTo(resolveState)) {
                ref.changeState(resolveState);
            }
        }
        if (data instanceof ObjectData) {
            this.updateObject(ref, data, resolveState);
        }
        return ref;
    }

    public String toString() {
        return "[" + (this.state == null ? null : this.state.getClassName() + "/" + this.state.getOid() + this.state) + "]";
    }

    public void updateObject(NakedObject object) {
        this.updateObject(object, this.state, ResolveState.RESOLVING);
    }

    private void updateObject(NakedObject object, Data state, ResolveState resolveState) {
        Oid oid = object.getOid();
        if (oid != null && !oid.equals(state.getOid())) {
            throw new IllegalArgumentException("This memento can only be used to update the naked object with the Oid " + state.getOid() + " but is " + oid);
        }
        if (!(state instanceof ObjectData)) {
            throw new NakedObjectException("Expected an ObjectData but got " + state.getClass());
        }
        this.updateObject(object, resolveState, state);
        LOG.debug((Object)("object updated " + object.getOid()));
    }

    private void updateObject(NakedObject object, ResolveState resolveState, Data state) {
        if (object.getResolveState().isValidToChangeTo(resolveState)) {
            PersistorUtil.start(object, resolveState);
            this.updateFields(object, state);
            PersistorUtil.end(object);
        } else if (object.getResolveState() == ResolveState.TRANSIENT && resolveState == ResolveState.TRANSIENT) {
            this.updateFields(object, state);
        } else {
            ObjectData od = (ObjectData)state;
            if (od.containsField()) {
                throw new NakedObjectException("Resolve state (for " + object + ") inconsistent with fact that data exists for fields");
            }
        }
    }

    private void updateFields(NakedObject object, Data state) {
        ObjectData od = (ObjectData)state;
        NakedObjectAssociation[] fields = object.getSpecification().getAssociations();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isPersisted()) continue;
            this.updateField(object, od, fields[i]);
        }
    }

    private void updateField(NakedObject object, ObjectData od, NakedObjectAssociation field) {
        Object fieldData = od.getEntry(field.getId());
        if (field.isOneToManyAssociation()) {
            this.updateOneToManyAssociation(object, (OneToManyAssociation)field, (CollectionData)fieldData);
        } else if (field.getSpecification().containsFacet(EncodeableFacet.class)) {
            EncodeableFacet facet = (EncodeableFacet)field.getSpecification().getFacet(EncodeableFacet.class);
            NakedObject value = facet.fromEncodedString((String)fieldData);
            ((OneToOneAssociation)field).initAssociation(object, value);
        } else if (field.isOneToOneAssociation()) {
            this.updateOneToOneAssociation(object, (OneToOneAssociation)field, (Data)fieldData);
        }
    }

    private void updateOneToManyAssociation(NakedObject object, OneToManyAssociation field, CollectionData collectionData) {
        NakedObject collection = field.get(object);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Vector original = new Vector();
        Enumeration elements = facet.elements(collection);
        while (elements.hasMoreElements()) {
            original.addElement(elements.nextElement());
        }
        for (int j = 0; j < collectionData.elements.length; ++j) {
            NakedObject element = this.recreateReference(collectionData.elements[j]);
            if (!facet.contains(collection, element)) {
                LOG.debug((Object)("  association " + field + " changed, added " + element.getOid()));
                field.addElement(object, element);
                continue;
            }
            field.removeElement(object, element);
        }
        int size = original.size();
        for (int i = 0; i < size; ++i) {
            NakedObject element = (NakedObject)original.elementAt(i);
            LOG.debug((Object)("  association " + field + " changed, removed " + element.getOid()));
            field.removeElement(object, element);
        }
    }

    private void updateOneToOneAssociation(NakedObject object, OneToOneAssociation field, Data fieldData) {
        if (fieldData == null) {
            field.initAssociation(object, null);
        } else {
            NakedObject ref = this.recreateReference(fieldData);
            if (field.get(object) != ref) {
                LOG.debug((Object)("  association " + field + " changed to " + ref.getOid()));
                field.initAssociation(object, ref);
            }
        }
    }

    protected Data getData() {
        return this.state;
    }

    public void encodedData(ByteEncoder encoder) {
        this.state.encode(encoder);
    }

    public void restore(ByteDecoder decoder) {
        this.state = (Data)decoder.getObject();
    }

    public void debug(DebugString debug) {
        this.state.debug(debug);
    }

    private static SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static PersistenceSessionHydrator getHydrator() {
        return Memento.getPersistenceSession();
    }
}

