/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import java.util.Enumeration;
import java.util.Hashtable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.runtime.memento.Data;
import org.nakedobjects.runtime.memento.Null;

class ObjectData
extends Data {
    private static final long serialVersionUID = 7121411963269613347L;
    private static final Encodable NO_ENTRY = new Null();
    private final Hashtable fields = new Hashtable();

    public ObjectData(Oid oid, String resolveState, String className) {
        super(oid, resolveState, className);
    }

    public ObjectData(ByteDecoder decoder) {
        super(decoder);
        int size = decoder.getInt();
        for (int i = 0; i < size; ++i) {
            String key = decoder.getString();
            String type = decoder.getString();
            if (type.equals("O")) {
                Data object = (Data)decoder.getObject();
                this.fields.put(key, object);
                continue;
            }
            String value = decoder.getString();
            this.fields.put(key, value);
        }
    }

    public void addField(String fieldName, Object entry) {
        if (this.fields.containsKey(fieldName)) {
            throw new IllegalArgumentException("Field already entered " + fieldName);
        }
        this.fields.put(fieldName, entry == null ? NO_ENTRY : entry);
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        Enumeration f = this.fields.keys();
        while (f.hasMoreElements()) {
            String key = (String)f.nextElement();
            Object value = this.fields.get(key);
            debug.appendln(key, value);
        }
    }

    public void encode(ByteEncoder encoder) {
        super.encode(encoder);
        encoder.add(this.fields.size());
        Enumeration f = this.fields.keys();
        while (f.hasMoreElements()) {
            String key = (String)f.nextElement();
            Object value = this.fields.get(key);
            encoder.add(key);
            if (value instanceof Data || value instanceof Null) {
                encoder.add("O");
                encoder.add(value);
                continue;
            }
            encoder.add("S");
            encoder.add((String)value);
        }
    }

    public Object getEntry(String fieldName) {
        Object entry = this.fields.get(fieldName);
        return entry == null || entry.getClass() == NO_ENTRY.getClass() ? null : entry;
    }

    public String toString() {
        return this.fields.toString();
    }

    public boolean containsField() {
        return this.fields != null && this.fields.size() > 0;
    }
}

