/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import java.io.Serializable;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.memento.Data;

public class StandaloneData
extends Data {
    private static final long serialVersionUID = 1L;
    private String objectAsEncodedString;
    private Serializable objectAsSerializable;

    public StandaloneData(NakedObject adapter) {
        super(null, adapter.getResolveState().name(), adapter.getSpecification().getFullName());
        Object object = adapter.getObject();
        if (object instanceof Serializable) {
            this.objectAsSerializable = (Serializable)object;
            return;
        }
        EncodeableFacet encodeableFacet = (EncodeableFacet)adapter.getSpecification().getFacet(EncodeableFacet.class);
        if (encodeableFacet != null) {
            this.objectAsEncodedString = encodeableFacet.toEncodedString(adapter);
            return;
        }
        throw new IllegalArgumentException("Object wrapped by standalone adapter is not serializable and its specificatoin does not have an EncodeableFacet");
    }

    public void encode(ByteEncoder encoder) {
        super.encode(encoder);
        if (this.objectAsSerializable != null) {
            encoder.add((Object)As.SERIALIZABLE);
            encoder.add((Object)this.objectAsSerializable);
        } else {
            encoder.add((Object)As.ENCODED_STRING);
            encoder.add(this.objectAsEncodedString);
        }
    }

    public StandaloneData(ByteDecoder decoder) {
        super(decoder);
        Object encodedAs = decoder.getObject();
        if (encodedAs.equals((Object)As.SERIALIZABLE)) {
            this.objectAsSerializable = (Serializable)decoder.getObject();
        } else {
            this.objectAsEncodedString = decoder.getString();
        }
    }

    public NakedObject getAdapter() {
        if (this.objectAsSerializable != null) {
            return NakedObjectsContext.getPersistenceSession().getAdapterManager().adapterFor(this.objectAsSerializable);
        }
        NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(this.getClassName());
        EncodeableFacet encodeableFacet = (EncodeableFacet)spec.getFacet(EncodeableFacet.class);
        return encodeableFacet.fromEncodedString(this.objectAsEncodedString);
    }

    private String getObjectAsEncodedString() {
        return this.objectAsEncodedString;
    }

    private Serializable getObjectAsSerializable() {
        return this.objectAsSerializable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum As {
        ENCODED_STRING,
        SERIALIZABLE;

    }
}

