/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory;

import org.nakedobjects.runtime.objectstore.inmemory.InMemoryObjectStore;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStoreInstances;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStorePersistedObjects;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStorePersistedObjectsDefault;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactoryDelegate;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactoryDelegating;
import org.nakedobjects.runtime.persistence.objectstore.PersistenceSessionObjectStore;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SimpleOidGenerator;
import org.nakedobjects.runtime.system.DeploymentType;

public class InMemoryPersistenceSessionFactory
extends PersistenceSessionFactoryDelegating {
    private ObjectStorePersistedObjects persistedObjects;

    public InMemoryPersistenceSessionFactory(DeploymentType deploymentType, PersistenceSessionFactoryDelegate persistenceSessionFactoryDelegate) {
        super(deploymentType, persistenceSessionFactoryDelegate);
    }

    protected ObjectStorePersistedObjects getPersistedObjects() {
        return this.persistedObjects;
    }

    public PersistenceSession createPersistenceSession() {
        PersistenceSessionObjectStore persistenceSession = (PersistenceSessionObjectStore)super.createPersistenceSession();
        InMemoryObjectStore inMemoryObjectStore = (InMemoryObjectStore)persistenceSession.getObjectStore();
        if (this.persistedObjects != null) {
            OidGenerator oidGenerator = persistenceSession.getOidGenerator();
            if (oidGenerator instanceof SimpleOidGenerator) {
                SimpleOidGenerator simpleOidGenerator = (SimpleOidGenerator)oidGenerator;
                simpleOidGenerator.resetTo(this.persistedObjects.getOidGeneratorMemento());
            }
            inMemoryObjectStore.attachPersistedObjects(this.persistedObjects);
            this.persistedObjects = null;
        }
        return persistenceSession;
    }

    public ObjectStorePersistedObjects createPersistedObjects() {
        return new ObjectStorePersistedObjectsDefault();
    }

    public void attach(PersistenceSession persistenceSession, ObjectStorePersistedObjects persistedObjects) {
        OidGenerator<?> oidGenerator = persistenceSession.getOidGenerator();
        if (oidGenerator instanceof SimpleOidGenerator) {
            SimpleOidGenerator simpleOidGenerator = (SimpleOidGenerator)oidGenerator;
            persistedObjects.saveOidGeneratorMemento(simpleOidGenerator.getMemento());
        }
        this.persistedObjects = persistedObjects;
    }

    protected void doShutdown() {
        if (this.persistedObjects != null) {
            for (ObjectStoreInstances inst : this.persistedObjects.instances()) {
                inst.shutdown();
            }
            this.persistedObjects.clear();
        }
    }
}

