/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaTitle;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStoreInstances {
    private final Map<Oid, Object> objectInstances = new HashMap<Oid, Object>();
    protected final Map<Oid, String> titleIndex = new HashMap<Oid, String>();

    public void shutdown() {
        this.getObjectInstances().clear();
        this.titleIndex.clear();
    }

    public void save(NakedObject object) {
        this.getObjectInstances().put(object.getOid(), object.getObject());
        this.titleIndex.put(object.getOid(), object.titleString().toLowerCase());
    }

    public void remove(Oid oid) {
        this.getObjectInstances().remove(oid);
        this.titleIndex.remove(oid);
    }

    public NakedObject retrieveObject(Oid oid) {
        Object pojo = this.getObjectInstances().get(oid);
        if (pojo == null) {
            return null;
        }
        NakedObject adapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        NakedObject adapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        return this.getHydrator().recreateAdapter(oid, pojo);
    }

    public void instances(InstancesCriteria criteria, Vector<NakedObject> instances) {
        if (criteria instanceof InstancesCriteriaTitle) {
            for (Oid oid : this.titleIndex.keySet()) {
                String title = this.titleIndex.get(oid);
                if (!((InstancesCriteriaTitle)criteria).matches(title)) continue;
                NakedObject adapter = this.retrieveObject(oid);
                instances.add(adapter);
            }
            return;
        }
        for (NakedObject element : this.elements()) {
            if (!criteria.matches(element)) continue;
            instances.addElement(element);
        }
    }

    public int numberOfInstances() {
        return this.getObjectInstances().size();
    }

    public boolean hasInstances() {
        return this.numberOfInstances() > 0;
    }

    private List<NakedObject> elements() {
        ArrayList<NakedObject> v = new ArrayList<NakedObject>(this.getObjectInstances().size());
        for (Oid oid : this.getObjectInstances().keySet()) {
            v.add(this.retrieveObject(oid));
        }
        return v;
    }

    public void debugData(DebugString debug) {
        debug.indent();
        if (this.getObjectInstances().size() == 0) {
            debug.appendln("no instances");
        }
        for (Oid oid : this.getObjectInstances().keySet()) {
            String title = this.titleIndex.get(oid);
            Object object = this.getObjectInstances().get(oid);
            debug.appendln(oid.toString(), (Object)(object + " (" + title + ")"));
        }
        debug.appendln();
        debug.unindent();
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    private PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }

    public Map<Oid, Object> getObjectInstances() {
        return this.objectInstances;
    }
}

