/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence;

import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.runtime.installers.InstallerAbstract;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupAware;
import org.nakedobjects.runtime.persistence.PersistenceConstants;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstaller;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.internal.RuntimeContextFromSession;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceMechanismInstallerAbstract
extends InstallerAbstract
implements PersistenceMechanismInstaller,
InstallerLookupAware {
    private static final Logger LOG = Logger.getLogger(PersistenceMechanismInstallerAbstract.class);
    private InstallerLookup installerLookup;

    @Override
    public PersistenceSession createPersistenceSession(PersistenceSessionFactory persistenceSessionFactory) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("installing " + this.getClass().getName()));
        }
        AdapterManagerExtended adapterManager = this.createAdapterManager(this.getConfiguration());
        AdapterFactory<?> adapterFactory = this.createAdapterFactory(this.getConfiguration());
        ObjectFactory objectFactory = this.createObjectFactory(this.getConfiguration());
        OidGenerator<?> oidGenerator = this.createOidGenerator(this.getConfiguration());
        RuntimeContext runtimeContext = this.createRuntimeContext(this.getConfiguration());
        DomainObjectContainer container = this.createContainer(this.getConfiguration());
        ServicesInjector servicesInjector = this.createServicesInjector(this.getConfiguration());
        List<Object> serviceList = persistenceSessionFactory.getServices();
        Ensure.ensureThatArg((Object)adapterManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)objectFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(oidGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)runtimeContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)container, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(serviceList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)servicesInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        runtimeContext.injectInto((Object)container);
        runtimeContext.setContainer(container);
        servicesInjector.setContainer(container);
        servicesInjector.setServices(serviceList);
        persistenceSessionFactory.getSpecificationLoader().injectInto((Object)runtimeContext);
        return this.createPersistenceSession(persistenceSessionFactory, adapterManager, adapterFactory, objectFactory, oidGenerator, servicesInjector);
    }

    protected abstract PersistenceSession createPersistenceSession(PersistenceSessionFactory var1, AdapterManagerExtended var2, AdapterFactory<?> var3, ObjectFactory var4, OidGenerator<?> var5, ServicesInjector var6);

    protected AdapterFactory<?> createAdapterFactory(NakedObjectConfiguration configuration) {
        String configuredClassName = configuration.getString("nakedobjects.persistor.adapter-factory", PersistenceConstants.ADAPTER_FACTORY_CLASS_NAME_DEFAULT);
        return (AdapterFactory)InstanceFactory.createInstance((String)configuredClassName, AdapterFactory.class);
    }

    protected ObjectFactory createObjectFactory(NakedObjectConfiguration configuration) {
        String configuredClassName = configuration.getString("nakedobjects.persistor.object-factory", PersistenceConstants.OBJECT_FACTORY_CLASS_NAME_DEFAULT);
        return (ObjectFactory)InstanceFactory.createInstance((String)configuredClassName, (String)PersistenceConstants.OBJECT_FACTORY_CLASS_NAME_DEFAULT, ObjectFactory.class);
    }

    protected ServicesInjector createServicesInjector(NakedObjectConfiguration configuration) {
        String configuredClassName = configuration.getString("nakedobjects.persistor.services-injector", PersistenceConstants.SERVICES_INJECTOR_CLASS_NAME_DEFAULT);
        return (ServicesInjector)InstanceFactory.createInstance((String)configuredClassName, ServicesInjector.class);
    }

    protected OidGenerator<?> createOidGenerator(NakedObjectConfiguration configuration) {
        String oidGeneratorClassName = configuration.getString("nakedobjects.persistor.oid-generator", PersistenceConstants.OID_GENERATOR_CLASS_NAME_DEFAULT);
        return (OidGenerator)InstanceFactory.createInstance((String)oidGeneratorClassName, OidGenerator.class);
    }

    protected AdapterManagerExtended createAdapterManager(NakedObjectConfiguration configuration) {
        return new AdapterManagerDefault();
    }

    protected RuntimeContext createRuntimeContext(NakedObjectConfiguration configuration) {
        return new RuntimeContextFromSession();
    }

    protected DomainObjectContainer createContainer(NakedObjectConfiguration configuration) {
        String configuredClassName = configuration.getString("nakedobjects.persistor.domain-object-container", PersistenceConstants.DOMAIN_OBJECT_CONTAINER_NAME_DEFAULT);
        return (DomainObjectContainer)InstanceFactory.createInstance((String)configuredClassName, (String)PersistenceConstants.DOMAIN_OBJECT_CONTAINER_NAME_DEFAULT, DomainObjectContainer.class);
    }

    @Override
    public void setInstallerLookup(InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
    }

    protected InstallerLookup getInstallerLookup() {
        return this.installerLookup;
    }
}

