/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.NakedObjectList;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.IntrospectableSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionAware;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydratorAware;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.services.ServiceUtil;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceSessionAbstract
implements PersistenceSession {
    private static final Logger LOG = Logger.getLogger(PersistenceSessionAbstract.class);
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final AdapterFactory<?> adapterFactory;
    private final ObjectFactory objectFactory;
    private final ServicesInjector servicesInjector;
    private final OidGenerator<?> oidGenerator;
    private final AdapterManagerExtended adapterManager;
    private boolean dirtiableSupport;
    private SpecificationLoader specificationLoader;
    private NakedObjectTransactionManager transactionManager;
    private State state;

    public PersistenceSessionAbstract(PersistenceSessionFactory persistenceSessionFactory, AdapterFactory<?> adapterFactory, ObjectFactory objectFactory, ServicesInjector servicesInjector, OidGenerator oidGenerator, AdapterManagerExtended identityMap) {
        Ensure.ensureThatArg((Object)persistenceSessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistence session factory required");
        Ensure.ensureThatArg(adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"adapter factory required");
        Ensure.ensureThatArg((Object)objectFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"object factory required");
        Ensure.ensureThatArg((Object)servicesInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"services injector required");
        Ensure.ensureThatArg((Object)oidGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"OID generator required");
        Ensure.ensureThatArg((Object)identityMap, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"identity map required");
        this.persistenceSessionFactory = persistenceSessionFactory;
        this.adapterFactory = adapterFactory;
        this.objectFactory = objectFactory;
        this.servicesInjector = servicesInjector;
        this.oidGenerator = oidGenerator;
        this.adapterManager = identityMap;
        this.setState(State.NOT_INITIALIZED);
    }

    @Override
    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }

    @Override
    public final void open() {
        this.ensureNotOpened();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("opening " + this));
        }
        Ensure.ensureThatState((Object)this.specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"SpecificationLoader missing");
        Ensure.ensureThatState((Object)this.transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"TransactionManager missing");
        this.injectInto(this.objectFactory);
        this.specificationLoader.injectInto((Object)this.objectFactory);
        this.servicesInjector.injectInto((Object)this.objectFactory);
        this.adapterFactory.injectInto(this.adapterManager);
        this.specificationLoader.injectInto((Object)this.adapterManager);
        this.oidGenerator.injectInto(this.adapterManager);
        this.specificationLoader.injectInto(this.oidGenerator);
        this.servicesInjector.open();
        this.adapterFactory.open();
        this.objectFactory.open();
        this.adapterManager.open();
        this.oidGenerator.open();
        this.doOpen();
        this.createServiceAdapters();
        this.setState(State.OPEN);
        this.doOpened();
    }

    @Override
    public final void close() {
        if (this.getState() == State.CLOSED) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("closing " + this));
        }
        this.doClose();
        this.adapterManager.close();
        this.servicesInjector.close();
        this.objectFactory.close();
        this.adapterFactory.close();
        this.oidGenerator.close();
        this.setState(State.CLOSED);
    }

    protected void doOpen() {
    }

    protected void doOpened() {
    }

    protected void doClose() {
    }

    private void createServiceAdapters() {
        this.getTransactionManager().startTransaction();
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            String serviceId;
            Oid existingOid;
            NakedObject adapter;
            NakedObjectSpecification serviceNoSpec = this.specificationLoader.loadSpecification(service.getClass());
            if (serviceNoSpec instanceof IntrospectableSpecification) {
                IntrospectableSpecification introspectableSpecification = (IntrospectableSpecification)serviceNoSpec;
                introspectableSpecification.markAsService();
            }
            if ((adapter = (existingOid = this.getOidForService(serviceId = ServiceUtil.id(service))) == null ? this.getAdapterManager().adapterFor(service) : this.getAdapterManager().recreateAdapter(existingOid, service)).getOid().isTransient()) {
                this.adapterManager.remapAsPersistent(adapter);
            }
            if (adapter.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
                adapter.changeState(ResolveState.RESOLVING);
                adapter.changeState(ResolveState.RESOLVED);
            }
            Oid persistentOid = adapter.getOid();
            this.registerService(serviceId, persistentOid);
        }
        this.getTransactionManager().endTransaction();
    }

    private State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    protected void ensureNotOpened() {
        if (this.getState() != State.NOT_INITIALIZED) {
            throw new IllegalStateException("Persistence session has already been initialized");
        }
    }

    protected void ensureOpen() {
        if (this.getState() != State.OPEN) {
            throw new IllegalStateException("Persistence session is not open");
        }
    }

    @Override
    public void testReset() {
    }

    @Override
    public NakedObject createInstance(NakedObjectSpecification specification) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating transient instance of " + specification));
        }
        Object pojo = specification.createObject(NakedObjectSpecification.CreationMode.INITIALIZE);
        return this.getAdapterManager().adapterFor(pojo);
    }

    @Override
    public NakedObject recreateAdapter(Oid oid, NakedObjectSpecification specification) {
        NakedObject adapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("recreating adapter for Oid: " + oid + " of type " + specification));
        }
        Object pojo = specification.createObject(NakedObjectSpecification.CreationMode.NO_INITIALIZE);
        return this.getAdapterManager().recreateAdapter(oid, pojo);
    }

    @Override
    public NakedObject recreateAdapter(Oid oid, Object pojo) {
        NakedObject adapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        NakedObject adapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("recreating adapter for Oid: " + oid + " for provided pojo "));
        }
        return this.getAdapterManager().recreateAdapter(oid, pojo);
    }

    @Override
    public NakedObject reload(Oid oid) {
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        this.reload(adapter);
        return adapter;
    }

    @Override
    public abstract void reload(NakedObject var1);

    @Override
    public NakedObject findInstances(InstancesCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException();
        }
        NakedObject[] instances = this.getInstances(criteria);
        NakedObjectSpecification specification = criteria.getSpecification();
        NakedObjectList results = new NakedObjectList(specification, instances);
        NakedObject collection = this.getAdapterManager().adapterFor(results);
        return collection;
    }

    protected abstract NakedObject[] getInstances(InstancesCriteria var1);

    public boolean isCheckObjectsForDirtyFlag() {
        return this.dirtiableSupport;
    }

    public void setDirtiableSupport(boolean checkObjectsForDirtyFlag) {
        this.dirtiableSupport = checkObjectsForDirtyFlag;
    }

    @Override
    public void objectChangedAllDirty() {
        if (!this.dirtiableSupport) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"marking as changed any objects that have been manually set as dirty");
        }
        for (NakedObject adapter : this.getAdapterManager()) {
            if (!adapter.getSpecification().isDirty(adapter)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  found dirty object " + adapter));
            }
            this.objectChanged(adapter);
            adapter.getSpecification().clearDirty(adapter);
        }
    }

    @Override
    public synchronized void clearAllDirty() {
        if (!this.isCheckObjectsForDirtyFlag()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"cleaning any manually dirtied objects");
        }
        for (NakedObject object : this.getAdapterManager()) {
            if (!object.getSpecification().isDirty(object)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  found dirty object " + object));
            }
            object.getSpecification().clearDirty(object);
        }
    }

    protected abstract Oid getOidForService(String var1);

    protected abstract void registerService(String var1, Oid var2);

    @Override
    public NakedObject getService(String id) {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!id.equals(ServiceUtil.id(service))) continue;
            return this.getService(service);
        }
        return null;
    }

    @Override
    public List<NakedObject> getServices() {
        List services = this.servicesInjector.getRegisteredServices();
        ArrayList<NakedObject> serviceAdapters = new ArrayList<NakedObject>();
        for (Object service : services) {
            serviceAdapters.add(this.getService(service));
        }
        return serviceAdapters;
    }

    private NakedObject getService(Object service) {
        Oid oid = this.getOidForService(ServiceUtil.id(service));
        return this.recreateAdapterForExistingService(oid, service);
    }

    public boolean hasServices() {
        return this.servicesInjector.getRegisteredServices().size() > 0;
    }

    private NakedObject recreateAdapterForExistingService(Oid oid, Object service) {
        NakedObject adapter = this.getAdapterManager().recreateAdapter(oid, service);
        if (adapter.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            adapter.changeState(ResolveState.RESOLVING);
            adapter.changeState(ResolveState.RESOLVED);
        }
        return adapter;
    }

    public void injectInto(Object candidate) {
        Object cast;
        if (PersistenceSessionAware.class.isAssignableFrom(candidate.getClass())) {
            cast = (PersistenceSessionAware)PersistenceSessionAware.class.cast(candidate);
            cast.setPersistenceSession(this);
        }
        if (PersistenceSessionHydratorAware.class.isAssignableFrom(candidate.getClass())) {
            cast = (PersistenceSessionHydratorAware)PersistenceSessionHydratorAware.class.cast(candidate);
            cast.setHydrator(this);
        }
    }

    public void debugData(DebugString debug) {
        debug.appendTitle(this.getClass().getName());
        debug.appendln("container", (Object)this.servicesInjector);
        debug.appendln();
        this.adapterManager.debugData(debug);
        debug.appendln();
        debug.appendln("manually dirtiable support (isDirty flag)?", this.dirtiableSupport);
        debug.appendTitle("OID Generator");
        this.oidGenerator.debugData(debug);
        debug.appendln();
        debug.appendTitle("Services");
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            String id = ServiceUtil.id(service);
            String serviceClassName = service.getClass().getName();
            Oid oidForService = this.getOidForService(id);
            String serviceId = id + (id.equals(serviceClassName) ? "" : " (" + serviceClassName + ")");
            debug.appendln(oidForService != null ? oidForService.toString() : "[NULL]", (Object)serviceId);
        }
        debug.appendln();
    }

    @Override
    public final AdapterFactory<? extends NakedObject> getAdapterFactory() {
        return this.adapterFactory;
    }

    public final OidGenerator getOidGenerator() {
        return this.oidGenerator;
    }

    @Override
    public final AdapterManagerExtended getAdapterManager() {
        return this.adapterManager;
    }

    @Override
    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    @Override
    public void setSpecificationLoader(SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
    }

    @Override
    public void setTransactionManager(NakedObjectTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public NakedObjectTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_INITIALIZED,
        OPEN,
        CLOSED;

    }
}

