/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence;

import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.logging.Logger;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.UnsupportedFindException;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceSessionLogger
extends Logger
implements PersistenceSession,
DebugInfo {
    private final PersistenceSession underlying;

    public PersistenceSessionLogger(PersistenceSession decorated, String logFileName) {
        super(logFileName, false);
        this.underlying = decorated;
    }

    public PersistenceSessionLogger(PersistenceSession decorated) {
        super(null, false);
        this.underlying = decorated;
    }

    @Override
    public void destroyObject(NakedObject object) {
        this.log("destroy " + object.getObject());
        this.underlying.destroyObject(object);
    }

    @Override
    public NakedObject findInstances(InstancesCriteria criteria) throws UnsupportedFindException {
        this.log("find instances matching " + criteria);
        return this.underlying.findInstances(criteria);
    }

    public void debugData(DebugString debug) {
        if (this.underlying instanceof DebugInfo) {
            this.underlying.debugData(debug);
        }
    }

    public String debugTitle() {
        if (this.underlying instanceof DebugInfo) {
            return this.underlying.debugTitle();
        }
        return "";
    }

    protected Class<?> getDecoratedClass() {
        return this.underlying.getClass();
    }

    @Override
    public NakedObject loadObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException {
        NakedObject object = this.underlying.loadObject(oid, hint);
        this.log("get object for " + oid + " (of type " + hint.getShortName() + ")", object.getObject());
        return object;
    }

    @Override
    public boolean hasInstances(NakedObjectSpecification specification) {
        boolean hasInstances = this.underlying.hasInstances(specification);
        this.log("has instances of " + specification.getShortName(), "" + hasInstances);
        return hasInstances;
    }

    @Override
    public boolean isFixturesInstalled() {
        boolean isInitialized = this.underlying.isFixturesInstalled();
        this.log("is initialized: " + isInitialized);
        return isInitialized;
    }

    @Override
    public void open() {
        this.log("opening " + this.underlying);
        this.underlying.open();
    }

    @Override
    public void close() {
        this.log("closing " + this.underlying);
        this.underlying.close();
    }

    @Override
    public void makePersistent(NakedObject object) {
        this.log("make object graph persistent: " + object);
        this.underlying.makePersistent(object);
    }

    @Override
    public void objectChanged(NakedObject object) {
        this.log("object changed " + object);
        this.underlying.objectChanged(object);
    }

    @Override
    public void reload(NakedObject object) {
        this.underlying.reload(object);
        this.log("reload: " + object);
    }

    @Override
    public void testReset() {
        this.log("reset object manager");
        this.underlying.testReset();
    }

    @Override
    public void resolveImmediately(NakedObject object) {
        this.underlying.resolveImmediately(object);
        this.log("Resolve immediately: " + object);
    }

    @Override
    public void resolveField(NakedObject object, NakedObjectAssociation field) {
        this.log("resolve eagerly object in field " + field + " of " + object);
        this.underlying.resolveField(object, field);
    }

    @Override
    public void objectChangedAllDirty() {
        this.log("saving changes");
        this.underlying.objectChangedAllDirty();
    }

    @Override
    public NakedObject getService(String id) {
        this.log("get service " + id);
        return this.underlying.getService(id);
    }

    @Override
    public List<NakedObject> getServices() {
        this.log("get services ");
        return this.underlying.getServices();
    }

    @Override
    public NakedObject createInstance(NakedObjectSpecification specification) {
        this.log("create instance " + specification);
        return this.underlying.createInstance(specification);
    }

    @Override
    public NakedObject recreateAdapter(Oid oid, NakedObjectSpecification specification) {
        this.log("recreate instance " + oid + " " + specification);
        return this.underlying.recreateAdapter(oid, specification);
    }

    @Override
    public void setSpecificationLoader(SpecificationLoader specificationLoader) {
        this.underlying.setSpecificationLoader(specificationLoader);
    }

    public OidGenerator getOidGenerator() {
        return this.underlying.getOidGenerator();
    }

    public AdapterFactory<?> getAdapterFactory() {
        return this.underlying.getAdapterFactory();
    }

    @Override
    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.underlying.getPersistenceSessionFactory();
    }

    @Override
    public ServicesInjector getServicesInjector() {
        return this.underlying.getServicesInjector();
    }

    @Override
    public NakedObjectTransactionManager getTransactionManager() {
        return this.underlying.getTransactionManager();
    }

    @Override
    public void setTransactionManager(NakedObjectTransactionManager transactionManager) {
        this.underlying.setTransactionManager(transactionManager);
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.underlying.getObjectFactory();
    }

    @Override
    public void clearAllDirty() {
        this.underlying.clearAllDirty();
    }

    @Override
    public NakedObject reload(Oid oid) {
        return this.underlying.reload(oid);
    }

    @Override
    public AdapterManager getAdapterManager() {
        return this.underlying.getAdapterManager();
    }

    @Override
    public NakedObject recreateAdapter(Oid oid, Object pojo) {
        return this.underlying.recreateAdapter(oid, pojo);
    }

    public void injectInto(Object candidate) {
        this.underlying.injectInto(candidate);
    }
}

