/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.adaptermanager;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.AggregatedOid;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.facets.object.aggregated.AggregatedFacet;
import org.nakedobjects.metamodel.facets.object.value.ValueFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.identifier.Identified;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.specloader.SpecificationLoaderAware;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactoryAware;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerAware;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.adaptermanager.internal.OidAdapterHashMap;
import org.nakedobjects.runtime.persistence.adaptermanager.internal.OidAdapterMap;
import org.nakedobjects.runtime.persistence.adaptermanager.internal.PojoAdapterHashMap;
import org.nakedobjects.runtime.persistence.adaptermanager.internal.PojoAdapterMap;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGeneratorAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterManagerDefault
implements AdapterManagerExtended,
DebugInfo,
AdapterFactoryAware,
SpecificationLoaderAware,
OidGeneratorAware {
    private static final Logger LOG = Logger.getLogger(AdapterManagerDefault.class);
    protected PojoAdapterMap pojoAdapterMap;
    protected OidAdapterMap oidAdapterMap;
    private AdapterFactory<?> adapterFactory;
    private SpecificationLoader specificationLoader;
    private OidGenerator oidGenerator;

    public void open() {
        Ensure.ensureThatState(this.adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)this.specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)this.oidGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        if (this.oidAdapterMap == null) {
            this.oidAdapterMap = new OidAdapterHashMap();
        }
        if (this.pojoAdapterMap == null) {
            this.pojoAdapterMap = new PojoAdapterHashMap();
        }
        this.oidAdapterMap.open();
        this.pojoAdapterMap.open();
    }

    public void close() {
        this.oidAdapterMap.close();
        this.pojoAdapterMap.close();
    }

    public void reset() {
        this.oidAdapterMap.reset();
        this.pojoAdapterMap.reset();
    }

    @Override
    public Iterator<NakedObject> iterator() {
        return this.getPojoAdapterMap().iterator();
    }

    @Override
    public NakedObject addExistingAdapter(NakedObject nakedObject) {
        this.map(nakedObject);
        return nakedObject;
    }

    @Override
    public NakedObject getAdapterFor(Object pojo) {
        Ensure.ensureThatArg((Object)pojo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return this.getPojoAdapterMap().getAdapter(pojo);
    }

    @Override
    public NakedObject getAdapterFor(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.ensureMapsConsistent(oid);
        return this.getOidAdapterMap().getAdapter(oid);
    }

    @Override
    public NakedObject adapterFor(Object pojo) {
        return this.adapterFor(pojo, null, null);
    }

    @Override
    public NakedObject adapterFor(Object pojo, NakedObject ownerAdapter, Identified identified) {
        NakedObject adapter = this.getAdapterFor(pojo);
        if (adapter != null) {
            return adapter;
        }
        NakedObjectSpecification noSpec = this.getSpecificationLoader().loadSpecification(pojo.getClass());
        if (noSpec.containsFacet(ValueFacet.class)) {
            return this.createStandaloneAdapter(pojo);
        }
        if (ownerAdapter != null && identified != null) {
            if (this.specIsIntrisicallyAggregated(noSpec)) {
                return this.map(this.createAggregatedObjectAdapter(ownerAdapter, identified.getIdentifier(), pojo));
            }
            if (this.aggregatedReference(identified) || this.specIsIntrisicallyAggregated(noSpec)) {
                return this.map(this.createAggregatedObjectAdapter(ownerAdapter, identified.getIdentifier(), pojo));
            }
        }
        return this.map(this.createRootAdapter(pojo));
    }

    private boolean specIsIntrisicallyAggregated(NakedObjectSpecification noSpec) {
        return noSpec.containsFacet(AggregatedFacet.class);
    }

    private boolean aggregatedReference(Identified identified) {
        return identified != null && identified.containsFacet(AggregatedFacet.class);
    }

    @Override
    public NakedObject recreateAdapter(Oid oid, Object pojo) {
        NakedObject adapterLookedUpByPojo = this.getAdapterFor(pojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        NakedObject adapterLookedUpByOid = this.getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        return this.map(this.createAdapter(pojo, oid));
    }

    @Override
    public void remapUpdated(Oid oid) {
        NakedObject lookedUpAdapter;
        Ensure.ensureThatArg((Object)oid.hasPrevious(), (Matcher)CoreMatchers.is((Object)true));
        Oid previousOid = oid.getPrevious();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remapping oid: " + oid + " with previous oid of: " + previousOid));
        }
        if ((lookedUpAdapter = this.oidAdapterMap.getAdapter(previousOid)) == null) {
            LOG.warn((Object)("could not locate previousOid: " + previousOid));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing previous oid" + previousOid));
        }
        this.oidAdapterMap.remove(previousOid);
        Oid lookedUpAdapterOid = lookedUpAdapter.getOid();
        lookedUpAdapterOid.copyFrom(oid);
        this.oidAdapterMap.add(lookedUpAdapterOid, lookedUpAdapter);
    }

    @Override
    public void removeAdapter(NakedObject adapter) {
        this.ensureMapsConsistent(adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing adapter: " + adapter));
        }
        this.unmap(adapter);
    }

    @Override
    public void remapAsPersistent(NakedObject adapter) {
        boolean removed;
        this.ensureMapsConsistent(adapter);
        Oid oid = adapter.getOid();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remapAsPersistent: " + oid));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"removing from maps");
        }
        if (!(removed = this.getOidAdapterMap().remove(oid))) {
            LOG.warn((Object)("could not remove oid: " + oid));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"updating the Oid");
        }
        this.getOidGenerator().convertTransientToPersistentOid(oid);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("readding into maps; oid is now: " + oid));
        }
        this.getOidAdapterMap().add(oid, adapter);
        adapter.changeState(ResolveState.RESOLVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("made persistent " + adapter + "; was " + oid.getPrevious()));
        }
    }

    @Override
    public NakedObject testCreateTransient(Object pojo, Oid oid) {
        if (!oid.isTransient()) {
            throw new IllegalArgumentException("Oid should be transient; use standard API to recreate adapters for persistent Oids");
        }
        return this.map(this.createAdapter(pojo, oid));
    }

    protected NakedObject createRootAdapter(Object pojo) {
        Object transientOid = this.getOidGenerator().createTransientOid(pojo);
        return this.createAdapter(pojo, (Oid)transientOid);
    }

    public NakedObject createAggregatedObjectAdapter(NakedObject parent, Identifier identifier, Object pojo) {
        this.ensureMapsConsistent(parent);
        Assert.assertNotNull((Object)pojo);
        AggregatedOid aggregatedOid = new AggregatedOid(parent.getOid(), identifier.getMemberName());
        NakedObject aggregatedAdapter = this.createAdapter(pojo, (Oid)aggregatedOid);
        aggregatedAdapter.setOptimisticLock(parent.getVersion());
        return aggregatedAdapter;
    }

    private NakedObject createStandaloneAdapter(Object pojo) {
        return this.createAdapter(pojo, null);
    }

    private NakedObject createAdapter(Object pojo, Oid oid) {
        Object adapter = this.getAdapterFactory().createAdapter(pojo, oid);
        if (oid == null) {
            adapter.changeState(ResolveState.STANDALONE);
        } else {
            adapter.changeState(oid.isTransient() ? ResolveState.TRANSIENT : ResolveState.GHOST);
        }
        return adapter;
    }

    private NakedObject map(NakedObject nakedObject) {
        Assert.assertNotNull((Object)nakedObject);
        Object object = nakedObject.getObject();
        Assert.assertFalse((String)"POJO Map already contains object", (Object)object, (boolean)this.getPojoAdapterMap().containsPojo(object));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding identity for nakedobject with oid=" + nakedObject.getOid()));
        }
        if (nakedObject.getResolveState().isStandalone()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"not mapping standalone adapter");
            }
            return nakedObject;
        }
        NakedObjectSpecification noSpec = nakedObject.getSpecification();
        if (!nakedObject.isAggregated() || nakedObject.isAggregated() && !noSpec.isImmutable()) {
            this.getPojoAdapterMap().add(object, nakedObject);
        }
        this.getOidAdapterMap().add(nakedObject.getOid(), nakedObject);
        return nakedObject;
    }

    private void unmap(NakedObject adapter) {
        this.ensureMapsConsistent(adapter);
        Oid oid = adapter.getOid();
        if (oid != null) {
            this.getOidAdapterMap().remove(oid);
        }
        this.getPojoAdapterMap().remove(adapter);
    }

    private void ensureMapsConsistent(NakedObject adapter) {
        if (adapter.getResolveState().isStandalone()) {
            return;
        }
        this.ensurePojoAdapterMapConsistent(adapter);
        this.ensureOidAdapterMapConsistent(adapter);
    }

    private void ensureMapsConsistent(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        NakedObject adapter = this.getOidAdapterMap().getAdapter(oid);
        if (adapter == null) {
            return;
        }
        this.ensureOidAdapterMapConsistent(adapter);
        this.ensurePojoAdapterMapConsistent(adapter);
    }

    private void ensurePojoAdapterMapConsistent(NakedObject adapter) {
        Object adapterPojo = adapter.getObject();
        NakedObject adapterAccordingToPojoAdapterMap = this.getPojoAdapterMap().getAdapter(adapterPojo);
        Ensure.ensureThatArg((Object)adapter, (Matcher)CoreMatchers.is((Object)adapterAccordingToPojoAdapterMap), (String)("mismatch in PojoAdapterMap: adapter's Pojo: " + adapterPojo + ", \n" + "provided adapter: " + adapter + "; \n" + " but map's adapter was : " + adapterAccordingToPojoAdapterMap));
    }

    private void ensureOidAdapterMapConsistent(NakedObject adapter) {
        Oid adapterOid = adapter.getOid();
        NakedObject adapterAccordingToOidAdapterMap = this.getOidAdapterMap().getAdapter(adapterOid);
        Ensure.ensureThatArg((Object)adapter, (Matcher)CoreMatchers.is((Object)adapterAccordingToOidAdapterMap), (String)("mismatch in OidAdapter map: adapter's Oid: " + adapterOid + ", " + "provided adapter: " + adapter + "; " + "map's adapter: " + adapterAccordingToOidAdapterMap));
    }

    public String debugTitle() {
        return "Identity map (adapter manager)";
    }

    public void debugData(DebugString debug) {
        debug.appendTitle(this.pojoAdapterMap.debugTitle());
        this.pojoAdapterMap.debugData(debug);
        debug.appendln();
        debug.appendTitle(this.oidAdapterMap.debugTitle());
        this.oidAdapterMap.debugData(debug);
    }

    public void injectInto(Object candidate) {
        if (AdapterManagerAware.class.isAssignableFrom(candidate.getClass())) {
            AdapterManagerAware cast = (AdapterManagerAware)AdapterManagerAware.class.cast(candidate);
            cast.setAdapterManager(this);
        }
    }

    private OidAdapterMap getOidAdapterMap() {
        return this.oidAdapterMap;
    }

    public void setOidAdapterMap(OidAdapterMap identityAdapterMap) {
        this.oidAdapterMap = identityAdapterMap;
    }

    private PojoAdapterMap getPojoAdapterMap() {
        return this.pojoAdapterMap;
    }

    public void setPojoAdapterMap(PojoAdapterMap pojoAdapterMap) {
        this.pojoAdapterMap = pojoAdapterMap;
    }

    public AdapterFactory<?> getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public void setAdapterFactory(AdapterFactory<?> adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    public void setSpecificationLoader(SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
    }

    public OidGenerator getOidGenerator() {
        return this.oidGenerator;
    }

    @Override
    public void setOidGenerator(OidGenerator<?> oidGenerator) {
        this.oidGenerator = oidGenerator;
    }
}

