/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.adaptermanager.internal;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.runtime.persistence.adaptermanager.internal.OidAdapterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidAdapterHashMap
implements OidAdapterMap {
    private static final Logger LOG = Logger.getLogger(OidAdapterHashMap.class);
    private static final int DEFAULT_OID_ADAPTER_MAP_SIZE = 10;
    private final Hashtable<Oid, NakedObject> adapterByOidMap;

    public OidAdapterHashMap() {
        this(10);
    }

    public OidAdapterHashMap(int capacity) {
        this.adapterByOidMap = new Hashtable(capacity);
    }

    public void open() {
    }

    public void close() {
        LOG.debug((Object)"close");
        this.adapterByOidMap.clear();
    }

    public void reset() {
        LOG.debug((Object)"reset");
        this.adapterByOidMap.clear();
    }

    @Override
    public void add(Oid oid, NakedObject adapter) {
        this.adapterByOidMap.put(oid, adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding oid: " + oid + " ; oid.hashCode: + " + oid.hashCode() + " ; adapter.hashCode(): " + adapter.hashCode()));
        }
    }

    @Override
    public boolean remove(Oid oid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remove " + oid));
        }
        return this.adapterByOidMap.remove(oid) != null;
    }

    @Override
    public NakedObject getAdapter(Oid oid) {
        return this.adapterByOidMap.get(oid);
    }

    @Override
    public Iterator<Oid> iterator() {
        return this.adapterByOidMap.keySet().iterator();
    }

    public String debugTitle() {
        return "Identity adapter map";
    }

    public void debugData(DebugString debug) {
        int count = 1;
        for (Oid oid : this) {
            NakedObject adapter = this.getAdapter(oid);
            debug.append(count++, 5);
            debug.append((Object)" '");
            debug.append((Object)oid.toString(), 15);
            debug.append((Object)"'    ");
            debug.appendln(adapter != null ? adapter.toString() : "(MISSING OBJECT ?!)");
        }
    }
}

