/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore;

import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CallbackUtils;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.NotPersistableException;
import org.nakedobjects.runtime.persistence.PersistenceSessionAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStorePersistence;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransaction;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManager;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceSessionObjectStore
extends PersistenceSessionAbstract
implements ToPersistObjectSet {
    private static final Logger LOG = Logger.getLogger(PersistenceSessionObjectStore.class);
    private final PersistAlgorithm persistAlgorithm;
    private final ObjectStorePersistence objectStore;

    public PersistenceSessionObjectStore(PersistenceSessionFactory persistenceSessionFactory, AdapterFactory<?> adapterFactory, ObjectFactory objectFactory, ServicesInjector servicesInjector, OidGenerator oidGenerator, AdapterManagerExtended identityMap, PersistAlgorithm persistAlgorithm, ObjectStorePersistence objectStore) {
        super(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, oidGenerator, identityMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating " + this));
        }
        Ensure.ensureThatArg((Object)persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persist algorithm required");
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"object store required");
        this.persistAlgorithm = persistAlgorithm;
        this.objectStore = objectStore;
    }

    @Override
    protected void doOpen() {
        Ensure.ensureThatState((Object)this.objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"object store required");
        Ensure.ensureThatState((Object)this.getTransactionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"transaction manager required");
        Ensure.ensureThatState((Object)this.persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"persist algorithm required");
        this.injectInto(this.objectStore);
        this.getAdapterManager().injectInto(this.objectStore);
        this.getSpecificationLoader().injectInto((Object)this.objectStore);
        this.getTransactionManager().injectInto(this.objectStore);
        this.getOidGenerator().injectInto(this.objectStore);
        this.objectStore.open();
    }

    @Override
    public boolean isFixturesInstalled() {
        return this.objectStore.isFixturesInstalled();
    }

    @Override
    protected void doClose() {
        this.objectStore.close();
    }

    @Override
    public void testReset() {
        this.objectStore.reset();
        this.getAdapterManager().reset();
        super.testReset();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)"finalizing object manager");
    }

    @Override
    public NakedObject loadObject(Oid oid, NakedObjectSpecification specification) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)specification, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter == null) {
            adapter = this.objectStore.getObject(oid, specification);
        }
        return adapter;
    }

    @Override
    public void reload(NakedObject object) {
    }

    @Override
    public void resolveField(NakedObject objectAdapter, NakedObjectAssociation field) {
        if (field.getSpecification().isMutableAggregated()) {
            return;
        }
        NakedObject referenceAdapter = field.get(objectAdapter);
        if (referenceAdapter == null || referenceAdapter.getResolveState().isResolved()) {
            return;
        }
        if (!referenceAdapter.isPersistent()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("resolve field " + objectAdapter.getSpecification().getShortName() + "." + field.getId() + ": " + referenceAdapter.getSpecification().getShortName() + " " + referenceAdapter.getResolveState().code() + " " + referenceAdapter.getOid()));
        }
        this.objectStore.resolveField(objectAdapter, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveImmediately(NakedObject adapter) {
        AuthenticationSession authenticationSession = NakedObjectsContext.getAuthenticationSession();
        synchronized (authenticationSession) {
            ResolveState resolveState = adapter.getResolveState();
            if (resolveState.canChangeTo(ResolveState.RESOLVING)) {
                Assert.assertFalse((String)"only resolve object that is not yet resolved", (Object)adapter, (boolean)resolveState.isResolved());
                Assert.assertTrue((String)"only resolve object that is persistent", (Object)adapter, (boolean)adapter.isPersistent());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("resolve immediately: " + adapter.getSpecification().getShortName() + " " + resolveState.code() + " " + adapter.getOid()));
                }
                CallbackUtils.callCallback((NakedObject)adapter, LoadingCallbackFacet.class);
                this.objectStore.resolveImmediately(adapter);
                CallbackUtils.callCallback((NakedObject)adapter, LoadedCallbackFacet.class);
            }
        }
    }

    @Override
    public void objectChanged(NakedObject adapter) {
        ResolveState resolveState = adapter.getResolveState();
        if (resolveState.respondToChangesInPersistentObjects()) {
            NakedObjectSpecification specification = adapter.getSpecification();
            if (SpecificationFacets.isAlwaysImmutable((NakedObjectSpecification)specification) || SpecificationFacets.isImmutableOncePersisted((NakedObjectSpecification)specification) && adapter.isPersistent()) {
                return;
            }
            CallbackUtils.callCallback((NakedObject)adapter, UpdatingCallbackFacet.class);
            SaveObjectCommand saveObjectCommand = this.objectStore.createSaveObjectCommand(adapter);
            this.getTransactionManager().addCommand(saveObjectCommand);
            CallbackUtils.callCallback((NakedObject)adapter, UpdatedCallbackFacet.class);
            ((ObjectStoreTransaction)this.getTransactionManager().getTransaction()).getUpdateNotifier().addChangedObject(adapter);
        }
        if (resolveState.respondToChangesInPersistentObjects() || adapter.isTransient()) {
            adapter.fireChangedEvent();
            this.getUpdateNotifier().addChangedObject(adapter);
        }
    }

    @Override
    public void makePersistent(NakedObject adapter) {
        if (adapter.isPersistent()) {
            throw new NotPersistableException("Object already persistent: " + adapter);
        }
        if (!adapter.getSpecification().persistability().isPersistable()) {
            throw new NotPersistableException("Object is not persistable: " + adapter);
        }
        NakedObjectSpecification specification = adapter.getSpecification();
        if (specification.isService()) {
            throw new NotPersistableException("Cannot persist services: " + adapter);
        }
        this.persistAlgorithm.makePersistent(adapter, this);
    }

    @Override
    public void destroyObject(NakedObject object) {
        LOG.info((Object)("destroyObject " + object));
        CallbackUtils.callCallback((NakedObject)object, RemovingCallbackFacet.class);
        DestroyObjectCommand command = this.objectStore.createDestroyObjectCommand(object);
        this.getTransactionManager().addCommand(command);
        CallbackUtils.callCallback((NakedObject)object, RemovedCallbackFacet.class);
    }

    @Override
    protected NakedObject[] getInstances(InstancesCriteria criteria) {
        LOG.info((Object)("getInstances matching " + criteria));
        NakedObject[] instances = this.objectStore.getInstances(criteria);
        this.clearAllDirty();
        return instances;
    }

    @Override
    public boolean hasInstances(NakedObjectSpecification specification) {
        LOG.info((Object)("hasInstances of " + specification.getShortName()));
        return this.objectStore.hasInstances(specification);
    }

    @Override
    protected Oid getOidForService(String name) {
        return this.objectStore.getOidForService(name);
    }

    @Override
    protected void registerService(String name, Oid oid) {
        this.objectStore.registerService(name, oid);
    }

    @Override
    public ObjectStoreTransactionManager getTransactionManager() {
        return (ObjectStoreTransactionManager)super.getTransactionManager();
    }

    @Override
    public void addPersistedObject(NakedObject object) {
        this.getTransactionManager().addCommand(this.objectStore.createCreateObjectCommand(object));
    }

    @Override
    public void madePersistent(NakedObject object) {
        this.getAdapterManager().remapAsPersistent(object);
    }

    @Override
    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendTitle("Persistor");
        this.getTransactionManager().debugData(debug);
        debug.appendln("Persist Algorithm", (Object)this.persistAlgorithm);
        debug.appendln("Object Store", (Object)this.objectStore);
        debug.appendln();
        this.objectStore.debugData(debug);
    }

    public String debugTitle() {
        return "Object Store Persistor";
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        if (this.objectStore != null) {
            toString.append("objectStore", this.objectStore.name());
        }
        if (this.persistAlgorithm != null) {
            toString.append("persistAlgorithm", this.persistAlgorithm.name());
        }
        return toString.toString();
    }

    private UpdateNotifier getUpdateNotifier() {
        return ((ObjectStoreTransaction)this.getTransactionManager().getTransaction()).getUpdateNotifier();
    }

    public ObjectStorePersistence getObjectStore() {
        return this.objectStore;
    }

    public PersistAlgorithm getPersistAlgorithm() {
        return this.persistAlgorithm;
    }
}

