/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.algorithm.dflt;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CallbackUtils;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;

public class DefaultPersistAlgorithm
extends PersistAlgorithmAbstract {
    private static final Logger LOG = Logger.getLogger(DefaultPersistAlgorithm.class);

    public String name() {
        return "Simple Bottom Up Persistence Walker";
    }

    public void makePersistent(NakedObject object, ToPersistObjectSet toPersistObjectSet) {
        if (object.getSpecification().isCollection()) {
            LOG.info((Object)("persist " + object));
            if (object.getResolveState() == ResolveState.GHOST) {
                object.changeState(ResolveState.RESOLVING);
                object.changeState(ResolveState.RESOLVED);
            } else if (object.getResolveState() == ResolveState.TRANSIENT) {
                object.changeState(ResolveState.RESOLVED);
            }
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)object);
            Enumeration elements = facet.elements(object);
            while (elements.hasMoreElements()) {
                NakedObject nextElement = (NakedObject)elements.nextElement();
                this.persist(nextElement, toPersistObjectSet);
            }
        } else {
            this.assertObjectNotPersistentAndPersistable(object);
            this.persist(object, toPersistObjectSet);
        }
    }

    protected void persist(NakedObject object, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistableOrServiceOrStandalone(object)) {
            return;
        }
        NakedObjectAssociation[] fields = object.getSpecification().getAssociations();
        if (!object.getSpecification().isEncodeable() && fields.length > 0) {
            LOG.info((Object)("make persistent " + object));
            CallbackUtils.callCallback((NakedObject)object, PersistingCallbackFacet.class);
            toPersistObjectSet.madePersistent(object);
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectAssociation field = fields[i];
                if (!field.isPersisted()) continue;
                if (field.isOneToManyAssociation()) {
                    NakedObject collection = field.get(object);
                    if (collection == null) {
                        throw new ObjectPersistenceException("Collection " + field.getName() + " does not exist in " + object.getSpecification().getFullName());
                    }
                    this.makePersistent(collection, toPersistObjectSet);
                    continue;
                }
                NakedObject fieldValue = field.get(object);
                if (fieldValue == null) continue;
                if (!(fieldValue instanceof NakedObject)) {
                    throw new UnknownTypeException(fieldValue + " is not a NakedObject");
                }
                this.persist(fieldValue, toPersistObjectSet);
            }
            toPersistObjectSet.addPersistedObject(object);
            CallbackUtils.callCallback((NakedObject)object, PersistedCallbackFacet.class);
        }
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

