/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.algorithm.twopass;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.util.CallbackUtils;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;

public class TwoPassPersistAlgorithm
extends PersistAlgorithmAbstract {
    private static final Logger LOG = Logger.getLogger(TwoPassPersistAlgorithm.class);

    public String name() {
        return "Two pass,  bottom up persistence walker";
    }

    public void makePersistent(NakedObject object, ToPersistObjectSet toPersistObjectSet) {
        if (object.getSpecification().isCollection()) {
            this.makeCollectionPersistent(object, toPersistObjectSet);
        } else {
            this.makeObjectPersistent(object, toPersistObjectSet);
        }
    }

    private void makeObjectPersistent(NakedObject object, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistableOrServiceOrStandalone(object)) {
            return;
        }
        NakedObjectAssociation[] fields = object.getSpecification().getAssociations();
        if (!object.getSpecification().isEncodeable() && fields.length > 0) {
            NakedObjectAssociation field;
            int i;
            LOG.info((Object)("persist " + object));
            CallbackUtils.callCallback((NakedObject)object, PersistingCallbackFacet.class);
            toPersistObjectSet.madePersistent(object);
            for (i = 0; i < fields.length; ++i) {
                NakedObject fieldValue;
                field = fields[i];
                if (!field.isPersisted() || field.isOneToManyAssociation() || (fieldValue = field.get(object)) == null) continue;
                if (!(fieldValue instanceof NakedObject)) {
                    throw new NakedObjectException();
                }
                this.makePersistent(fieldValue, toPersistObjectSet);
            }
            for (i = 0; i < fields.length; ++i) {
                field = fields[i];
                if (field.isPersisted() || !(field instanceof OneToManyAssociation)) continue;
                NakedObject collection = field.get(object);
                if (collection == null) {
                    throw new ObjectPersistenceException("Collection " + field.getName() + " does not exist in " + object.getSpecification().getFullName());
                }
                this.makePersistent(collection, toPersistObjectSet);
                CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
                Enumeration elements = facet.elements(collection);
                while (elements.hasMoreElements()) {
                    this.makePersistent((NakedObject)elements.nextElement(), toPersistObjectSet);
                }
            }
            toPersistObjectSet.addPersistedObject(object);
            CallbackUtils.callCallback((NakedObject)object, PersistedCallbackFacet.class);
        }
    }

    private void makeCollectionPersistent(NakedObject collection, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistable(collection)) {
            return;
        }
        LOG.info((Object)("persist " + collection));
        if (collection.getResolveState() == ResolveState.TRANSIENT) {
            collection.changeState(ResolveState.RESOLVED);
        }
        toPersistObjectSet.madePersistent(collection);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Enumeration elements = facet.elements(collection);
        while (elements.hasMoreElements()) {
            this.makePersistent((NakedObject)elements.nextElement(), toPersistObjectSet);
        }
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

