/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionAbstract;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.PersistenceCommand;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStoreTransaction
extends NakedObjectTransactionAbstract {
    private static final Logger LOG = Logger.getLogger(ObjectStoreTransaction.class);
    private final ObjectStoreTransactionManagement objectStore;
    private final List<PersistenceCommand> commands = new ArrayList<PersistenceCommand>();

    public ObjectStoreTransaction(NakedObjectTransactionManager transactionManager, MessageBroker messageBroker, UpdateNotifier updateNotifier, ObjectStoreTransactionManagement objectStore) {
        super(transactionManager, messageBroker, updateNotifier);
        this.objectStore = objectStore;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new transaction " + this));
        }
    }

    public void addCommand(PersistenceCommand command) {
        if (command == null) {
            return;
        }
        NakedObject onObject = command.onObject();
        if (command instanceof SaveObjectCommand) {
            if (this.alreadyHasCreate(onObject) || this.alreadyHasSave(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ignored command as object already created/saved" + command));
                }
                return;
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("ignored command " + command + " as object no longer exists"));
                }
                return;
            }
        }
        if (command instanceof DestroyObjectCommand) {
            if (this.alreadyHasCreate(onObject)) {
                this.removeCreate(onObject);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("ignored both create and destroy command " + command));
                }
                return;
            }
            if (this.alreadyHasSave(onObject)) {
                this.removeSave(onObject);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("removed prior save command " + command));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("add command " + command));
        }
        this.commands.add(command);
    }

    @Override
    public void doAbort() {
    }

    @Override
    public void doFlush() {
        if (this.commands.size() > 0) {
            this.objectStore.execute(Collections.unmodifiableList(this.commands));
            for (PersistenceCommand command : this.commands) {
                if (!(command instanceof DestroyObjectCommand)) continue;
                NakedObject adapter = command.onObject();
                adapter.setOptimisticLock(null);
                adapter.changeState(ResolveState.DESTROYED);
            }
            this.commands.clear();
        }
    }

    private boolean alreadyHasCommand(Class<?> commandClass, NakedObject onObject) {
        return this.getCommand(commandClass, onObject) != null;
    }

    private boolean alreadyHasCreate(NakedObject onObject) {
        return this.alreadyHasCommand(CreateObjectCommand.class, onObject);
    }

    private boolean alreadyHasDestroy(NakedObject onObject) {
        return this.alreadyHasCommand(DestroyObjectCommand.class, onObject);
    }

    private boolean alreadyHasSave(NakedObject onObject) {
        return this.alreadyHasCommand(SaveObjectCommand.class, onObject);
    }

    private PersistenceCommand getCommand(Class<?> commandClass, NakedObject onObject) {
        for (PersistenceCommand command : this.commands) {
            if (!command.onObject().equals(onObject) || !commandClass.isAssignableFrom(command.getClass())) continue;
            return command;
        }
        return null;
    }

    private void removeCommand(Class<?> commandClass, NakedObject onObject) {
        PersistenceCommand toDelete = this.getCommand(commandClass, onObject);
        this.commands.remove(toDelete);
    }

    private void removeCreate(NakedObject onObject) {
        this.removeCommand(CreateObjectCommand.class, onObject);
    }

    private void removeSave(NakedObject onObject) {
        this.removeCommand(SaveObjectCommand.class, onObject);
    }

    @Override
    protected ToString appendTo(ToString str) {
        super.appendTo(str);
        str.append("commands", this.commands.size());
        return str;
    }
}

