/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.transaction;

import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManagerAbstract;
import org.nakedobjects.runtime.transaction.PersistenceCommand;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStoreTransactionManager
extends NakedObjectTransactionManagerAbstract<ObjectStoreTransaction> {
    private static final Logger LOG = Logger.getLogger(ObjectStoreTransactionManager.class);
    private final PersistenceSessionTransactionManagement objectPersistor;
    private final ObjectStoreTransactionManagement objectStore;
    int transactionLevel;

    public ObjectStoreTransactionManager(PersistenceSessionTransactionManagement objectPersistor, ObjectStoreTransactionManagement objectStore) {
        this.objectPersistor = objectPersistor;
        this.objectStore = objectStore;
    }

    @Override
    public void startTransaction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"startTransaction");
        }
        if (this.getTransaction() == null || ((ObjectStoreTransaction)this.getTransaction()).getState().isComplete()) {
            this.createTransaction();
            this.transactionLevel = 0;
            this.objectStore.startTransaction();
        }
        ++this.transactionLevel;
    }

    @Override
    public boolean flushTransaction() {
        if (this.getTransaction() != null) {
            this.objectPersistor.objectChangedAllDirty();
            ((ObjectStoreTransaction)this.getTransaction()).flush();
        }
        return false;
    }

    @Override
    public void endTransaction() {
        --this.transactionLevel;
        if (this.transactionLevel == 0) {
            this.objectPersistor.objectChangedAllDirty();
            ((ObjectStoreTransaction)this.getTransaction()).commit();
            this.objectStore.endTransaction();
        } else if (this.transactionLevel < 0) {
            this.transactionLevel = 0;
            throw new IllegalStateException("No transaction running to end");
        }
    }

    @Override
    public void abortTransaction() {
        if (this.getTransaction() != null) {
            ((ObjectStoreTransaction)this.getTransaction()).abort();
            this.transactionLevel = 0;
            this.objectStore.abortTransaction();
        }
    }

    public void addCommand(PersistenceCommand command) {
        ((ObjectStoreTransaction)this.getTransaction()).addCommand(command);
    }

    @Override
    protected ObjectStoreTransaction createTransaction(MessageBroker messageBroker, UpdateNotifier updateNotifier) {
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)updateNotifier, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        return new ObjectStoreTransaction(this, messageBroker, updateNotifier, this.objectStore);
    }
}

