/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.oidgenerator.simple;

import java.io.Serializable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.ensure.Assert;

public final class SerialOid
implements Oid,
Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int hashCode;
    private State state;
    private SerialOid previous;
    private long serialNo;
    private String toString;

    public static SerialOid createPersistent(long serialNo) {
        return new SerialOid(serialNo, State.PERSISTENT);
    }

    public static SerialOid createTransient(long serialNo) {
        return new SerialOid(serialNo, State.TRANSIENT);
    }

    private SerialOid(long serialNo, State state) {
        this.serialNo = serialNo;
        this.state = state;
        this.cacheState();
    }

    public SerialOid(ByteDecoder decoder) {
        this.serialNo = decoder.getLong();
        this.state = SerialOid.decodeState(decoder);
        boolean hasPrevious = decoder.getBoolean();
        if (hasPrevious) {
            long previousSerialNo = decoder.getLong();
            this.previous = new SerialOid(previousSerialNo, SerialOid.decodeState(decoder));
        }
        this.cacheState();
    }

    public boolean isTransient() {
        return this.state.isTransient();
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.serialNo);
        this.encodeState(encoder);
        encoder.add(this.previous != null);
        if (this.previous != null) {
            encoder.add(this.previous.serialNo);
            this.previous.encodeState(encoder);
        }
    }

    private void encodeState(ByteEncoder encoder) {
        encoder.add(this.state.isTransient());
    }

    private static State decodeState(ByteDecoder decoder) {
        return decoder.getBoolean() ? State.TRANSIENT : State.PERSISTENT;
    }

    public void copyFrom(Oid oid) {
        Assert.assertTrue((boolean)(oid instanceof SerialOid));
        SerialOid from = (SerialOid)oid;
        this.serialNo = from.serialNo;
        this.state = from.state;
        this.cacheState();
    }

    public Oid getPrevious() {
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public void clearPrevious() {
        this.previous = null;
    }

    public void makePersistent(long serialNo) {
        Assert.assertTrue((boolean)this.state.isTransient());
        this.previous = new SerialOid(this.serialNo, this.state);
        this.serialNo = serialNo;
        this.state = State.PERSISTENT;
        this.cacheState();
    }

    public long getSerialNo() {
        return this.serialNo;
    }

    private void cacheState() {
        this.hashCode = 17;
        this.hashCode = 37 * this.hashCode + (int)(this.serialNo ^ this.serialNo >>> 32);
        this.hashCode = 37 * this.hashCode + (this.isTransient() ? 0 : 1);
        this.toString = (this.isTransient() ? "T" : "") + "OID#" + Long.toHexString(this.serialNo).toUpperCase() + (this.previous == null ? "" : "+");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((SerialOid)other);
    }

    public boolean equals(SerialOid other) {
        return other.serialNo == this.serialNo && other.state == this.state;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        PERSISTENT,
        TRANSIENT;


        public boolean isTransient() {
            return this == TRANSIENT;
        }
    }
}

