/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.oidgenerator.simple;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGeneratorAbstract;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOidGenerator
extends OidGeneratorAbstract<SerialOid> {
    private long persistentSerialNumber;
    private long transientSerialNumber;

    public SimpleOidGenerator() {
        this(1L);
    }

    public SimpleOidGenerator(long seed) {
        this(seed, -seed);
    }

    public SimpleOidGenerator(Memento memento) {
        this(memento.getPersistentSerialNumber(), memento.getTransientSerialNumber());
    }

    private SimpleOidGenerator(long persistentSerialNumber, long transientSerialNumber2) {
        Ensure.ensureThatArg((Object)persistentSerialNumber, (Matcher)CoreMatchers.is((Matcher)NofMatchers.greaterThan((Comparable)Long.valueOf(0L))));
        this.persistentSerialNumber = persistentSerialNumber;
        this.transientSerialNumber = transientSerialNumber2;
    }

    public String name() {
        return "Simple Serial OID Generator";
    }

    @Override
    public synchronized SerialOid createTransientOid(Object object) {
        return SerialOid.createTransient(this.transientSerialNumber--);
    }

    @Override
    public synchronized void convertTransientToPersistentOid(SerialOid oid) {
        Assert.assertTrue((boolean)(oid instanceof SerialOid));
        SerialOid serialOid = oid;
        serialOid.makePersistent(this.persistentSerialNumber++);
    }

    public Memento getMemento() {
        return new Memento(this.persistentSerialNumber, this.transientSerialNumber);
    }

    public void resetTo(Memento memento) {
        this.persistentSerialNumber = memento.getPersistentSerialNumber();
        this.transientSerialNumber = memento.getTransientSerialNumber();
    }

    public void debugData(DebugString debug) {
        debug.appendln("Persistent", this.persistentSerialNumber);
        debug.appendln("Transient", this.transientSerialNumber);
    }

    public String debugTitle() {
        return this.name();
    }

    public static class Memento {
        private long persistentSerialNumber;
        private long transientSerialNumber;

        Memento(long persistentSerialNumber, long transientSerialNumber) {
            this.persistentSerialNumber = persistentSerialNumber;
            this.transientSerialNumber = transientSerialNumber;
        }

        public long getTransientSerialNumber() {
            return this.transientSerialNumber;
        }

        public long getPersistentSerialNumber() {
            return this.persistentSerialNumber;
        }
    }
}

