/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.session;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.component.SessionScopedComponent;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.userprofile.UserProfile;

public class NakedObjectSessionDefault
implements NakedObjectSession {
    private static final Logger LOG = Logger.getLogger(NakedObjectSessionDefault.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM HH:mm:ss,SSS");
    private static int nextId = 1;
    private final NakedObjectSessionFactory executionContextFactory;
    private final AuthenticationSession authenticationSession;
    private PersistenceSession persistenceSession;
    private final UserProfile userProfile;
    private final int id;
    private long accessTime;
    private String debugSnapshot;

    public NakedObjectSessionDefault(NakedObjectSessionFactory sessionFactory, AuthenticationSession authenticationSession, PersistenceSession persistenceSession, UserProfile userProfile) {
        Ensure.ensureThatArg((Object)sessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"execution context factory is required");
        Ensure.ensureThatArg((Object)authenticationSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"authentication session is required");
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistence session is required");
        Ensure.ensureThatArg((Object)userProfile, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"user profile is required");
        this.executionContextFactory = sessionFactory;
        this.authenticationSession = authenticationSession;
        this.persistenceSession = persistenceSession;
        this.userProfile = userProfile;
        this.setSessionOpenTime(System.currentTimeMillis());
        this.id = nextId++;
    }

    public void open() {
        this.authenticationSession.open();
        this.persistenceSession.open();
    }

    public void close() {
        this.takeSnapshot();
        this.getPersistenceSession().close();
    }

    public void closeAll() {
        this.close();
        this.shutdownIfRequired(this.persistenceSession);
    }

    private void shutdownIfRequired(Object o) {
        if (o instanceof SessionScopedComponent) {
            SessionScopedComponent requiresSetup = (SessionScopedComponent)o;
            requiresSetup.close();
        }
    }

    public NakedObjectSessionFactory getSessionFactory() {
        return this.executionContextFactory;
    }

    public DeploymentType getDeploymentType() {
        return this.executionContextFactory.getDeploymentType();
    }

    public NakedObjectConfiguration getConfiguration() {
        return this.executionContextFactory.getConfiguration();
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.executionContextFactory.getSpecificationLoader();
    }

    public TemplateImageLoader getTemplateImageLoader() {
        return this.executionContextFactory.getTemplateImageLoader();
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    private String getSessionUserName() {
        return this.getAuthenticationSession().getUserName();
    }

    public String getId() {
        return "#" + this.id + this.getSessionUserName();
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    protected long getSessionOpenTime() {
        return this.accessTime;
    }

    private void setSessionOpenTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public NakedObjectTransaction getCurrentTransaction() {
        return this.getTransactionManager().getTransaction();
    }

    public void testSetObjectPersistor(PersistenceSession objectPersistor) {
        this.persistenceSession = objectPersistor;
    }

    public String toString() {
        ToString asString = new ToString((Object)this);
        asString.append("context", this.getId());
        this.appendState(asString);
        return asString.toString();
    }

    public void debugAll(DebugString debug) {
        debug.startSection("Naked Objects Context Snapshot");
        debug.appendln(this.debugSnapshot);
        debug.endSection();
    }

    public void debug(DebugString debug) {
        debug.appendAsHexln("hash", (long)this.hashCode());
        debug.appendln("context id", (long)this.id);
        debug.appendln("accessed", (Object)DATE_FORMAT.format(new Date(this.getSessionOpenTime())));
        this.debugState(debug);
    }

    public void takeSnapshot() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        DebugString debug = new DebugString();
        this.debug(debug);
        debug.indent();
        debug.appendln();
        this.debug(debug, this.getPersistenceSession());
        if (this.getCurrentTransaction() != null) {
            this.debug(debug, this.getCurrentTransaction().getUpdateNotifier());
            this.debug(debug, this.getCurrentTransaction().getMessageBroker());
        }
        this.debugSnapshot = debug.toString();
        LOG.debug((Object)this.debugSnapshot);
    }

    private void debug(DebugString debug, Object object) {
        if (object instanceof DebugInfo) {
            DebugInfo d = (DebugInfo)object;
            debug.startSection(d.debugTitle());
            d.debugData(debug);
            debug.endSection();
        } else {
            debug.appendln("no debug for " + object);
        }
    }

    public void appendState(ToString asString) {
        asString.append("authenticationSession", (Object)this.getAuthenticationSession());
        asString.append("persistenceSession", (Object)this.getPersistenceSession());
        asString.append("transaction", (Object)this.getCurrentTransaction());
        if (this.getCurrentTransaction() != null) {
            asString.append("messageBroker", (Object)this.getCurrentTransaction().getMessageBroker());
            asString.append("updateNotifier", (Object)this.getCurrentTransaction().getUpdateNotifier());
        }
    }

    public void debugState(DebugString debug) {
        debug.appendln("authenticationSession", (Object)this.getAuthenticationSession());
        debug.appendln("persistenceSession", (Object)this.getPersistenceSession());
        debug.appendln("transaction", (Object)this.getCurrentTransaction());
        if (this.getCurrentTransaction() != null) {
            debug.appendln("messageBroker", (Object)this.getCurrentTransaction().getMessageBroker());
            debug.appendln("updateNotifier", (Object)this.getCurrentTransaction().getUpdateNotifier());
        }
    }

    private NakedObjectTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }
}

