/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.snapshot;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.nakedobjects.runtime.snapshot.DomSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DomSerializerHandCrafted
implements DomSerializer {
    public String serialize(Element domElement) {
        StringBuffer buf = new StringBuffer();
        this.serializeToBuffer(domElement, buf);
        return buf.toString();
    }

    private void serializeToBuffer(Element el, StringBuffer buf) {
        buf.append("<").append(el.getTagName());
        NamedNodeMap attributeMap = el.getAttributes();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            Node node = attributeMap.item(i);
            if (node.getNodeType() != 2) continue;
            Attr attr = (Attr)node;
            buf.append(" ").append(attr.getName()).append("=\"").append(attr.getValue()).append("\"");
        }
        buf.append(">");
        NodeList nodeList = el.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                Text text = (Text)node;
                buf.append(text.getData());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            Element childEl = (Element)node;
            this.serializeToBuffer(childEl, buf);
        }
        buf.append("</").append(el.getTagName()).append(">");
    }

    public void serializeTo(Element domElement, OutputStream os) {
        StringBuffer buf = new StringBuffer();
        this.serializeToBuffer(domElement, buf);
        PrintStream printer = new PrintStream(os);
        printer.println(buf.toString());
        printer.flush();
    }

    public void serializeTo(Element domElement, Writer w) {
        StringBuffer buf = new StringBuffer();
        this.serializeToBuffer(domElement, buf);
        PrintWriter printer = new PrintWriter(w);
        printer.println(buf.toString());
        printer.flush();
    }
}

