/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import org.nakedobjects.runtime.system.DeploymentCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DeploymentType {
    EXPLORATION(false, false, DeploymentCategory.EXPLORING),
    PROTOTYPE(false, false, DeploymentCategory.PROTOTYPING),
    STANDALONE(false, false, DeploymentCategory.PRODUCTION),
    CLIENT(true, false, DeploymentCategory.PRODUCTION),
    SERVER_EXPLORATION(false, true, DeploymentCategory.EXPLORING),
    SERVER_PROTOTYPE(false, true, DeploymentCategory.PROTOTYPING),
    SERVER(false, true, DeploymentCategory.PRODUCTION);

    private final boolean isClientSideOnly;
    private final boolean isServerSideOnly;
    private final DeploymentCategory category;

    private DeploymentType(boolean isClientSideOnly, boolean isServerSideOnly, DeploymentCategory category) {
        this.isClientSideOnly = isClientSideOnly;
        this.isServerSideOnly = isServerSideOnly;
        this.category = category;
    }

    public boolean isClientSideOnly() {
        return this.isClientSideOnly;
    }

    public boolean isServerSideOnly() {
        return this.isServerSideOnly;
    }

    public boolean canSpecifyRemoting() {
        return this.isClientSideOnly() || this.isServerSideOnly();
    }

    public boolean hasViewer() {
        return !this.isServerSideOnly();
    }

    public boolean canSpecifyObjectStore() {
        return this.isProduction() && !this.isClientSideOnly();
    }

    public boolean isMultithreaded() {
        return this.isServerSideOnly() && this.isProduction();
    }

    public boolean isExploring() {
        return this.category == DeploymentCategory.EXPLORING;
    }

    public boolean isPrototyping() {
        return this.category == DeploymentCategory.PROTOTYPING;
    }

    public boolean isProduction() {
        return this.category == DeploymentCategory.PRODUCTION;
    }

    public boolean shouldMonitor() {
        return this.isServerSideOnly() && this.isProduction();
    }
}

