/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.internal.console;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.internal.console.Server;
import org.nakedobjects.runtime.system.internal.console.ServerConsole;

public class AWTConsole
extends Frame
implements ServerConsole {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AWTConsole.class);
    public static final String WIDTH = "nakedobjects.awt-console.width";
    public static final String HEIGHT = "nakedobjects.awt-console.height";
    public static final int DEFAULT_WIDTH = 600;
    public static final int DEFAULT_HEIGHT = 350;
    private Server server;
    private TextArea log;
    private Button quit;

    public AWTConsole() {
        super("Object Server Console");
        this.buildGUI();
        this.setVisible(true);
    }

    private void addButtons() {
        Panel p = new Panel();
        p.setLayout(new GridLayout(1, 0, 10, 0));
        this.add((Component)p, "South");
        Button b = new Button("Blank");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWTConsole.this.clearLog();
            }
        });
        b = new Button("Classes");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWTConsole.this.listClasses();
            }
        });
        b = new Button("Cache");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWTConsole.this.listCachedObjects();
            }
        });
        b = new Button("C/Cache");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWTConsole.this.clearCache();
            }
        });
        this.quit = new Button("Quit");
        p.add(this.quit);
        this.quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AWTConsole.this.quit();
            }
        });
    }

    private void buildGUI() {
        this.log = new TextArea();
        this.add(this.log);
        this.addButtons();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension();
        Insets insets = this.getInsets();
        frameSize.width = NakedObjectsContext.getConfiguration().getInteger(WIDTH, 600);
        frameSize.height = NakedObjectsContext.getConfiguration().getInteger(HEIGHT, 350);
        Rectangle bounds = new Rectangle(frameSize);
        bounds.x = screenSize.width - frameSize.width - insets.right;
        bounds.y = 0 + insets.top;
        this.setBounds(bounds);
    }

    private void clearCache() {
    }

    private void clearLog() {
        this.log.setText("");
    }

    public void close() {
        this.dispose();
    }

    public void init(Server server) {
        this.server = server;
        this.log("Console in control of " + server);
    }

    private void listCachedObjects() {
    }

    private void listClasses() {
    }

    public void log() {
        this.log.append("\n");
    }

    public void log(String message) {
        this.log.append(message + '\n');
        LOG.info((Object)message);
    }

    public void quit() {
        this.server.shutdown();
        this.close();
        System.exit(0);
    }
}

