/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.internal.monitor;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.system.internal.monitor.AbstractServerMonitor;
import org.nakedobjects.runtime.system.internal.monitor.MonitorListenerImpl;

public class HttpServerMonitor
extends AbstractServerMonitor {
    private static final Logger LOG = Logger.getLogger(HttpServerMonitor.class);
    private static final int DEFAULT_PORT = 8081;
    private static final String PORT = "nakedobjects.monitor.http.port";
    private final MonitorListenerImpl monitor = new MonitorListenerImpl();

    protected int getPort() {
        return NakedObjectsContext.getConfiguration().getInteger(PORT, 8081);
    }

    protected boolean handleRequest(PrintWriter writer, String request) throws IOException {
        if (request == null || request.length() == 0) {
            LOG.info((Object)"Connection dropped");
            return false;
        }
        StringTokenizer st = new StringTokenizer(request);
        if (st.countTokens() != 3) {
            this.httpErrorResponse(writer, 444, "Unparsable input " + request);
            return false;
        }
        String type = st.nextToken();
        if (!type.equals("GET")) {
            this.httpErrorResponse(writer, 400, "Invalid method " + type);
            return false;
        }
        String query = st.nextToken();
        if ((query = URLDecoder.decode(query, "UTF-8")).equals("/")) {
            query = "/monitor";
        }
        if (query.startsWith("/monitor")) {
            if ((query = query.substring("/monitor".length())).startsWith("?")) {
                query = query.substring(1);
            }
            this.monitor.writeHtmlPage(query, writer);
        } else {
            this.httpErrorResponse(writer, 404, "Failed to find " + query);
            writer.println("[Request: HTTP/1.0 200");
            writer.println("Content-Type: text/html");
            writer.println("]");
        }
        return false;
    }

    private void httpErrorResponse(PrintWriter writer, int errorNo, String response) {
        writer.println("HTTP/1.0 " + errorNo + " " + response);
        writer.println("Content-Type: text/html");
        writer.println("");
        writer.println("<HTML><HEAD><TITLE>Error " + errorNo + " - " + response + "</TITLE></HEAD>");
        writer.println("<BODY><h1>" + errorNo + " - " + response + "</h1>");
        writer.println("</BODY></HTML>");
        writer.flush();
    }

    public void setTarget(NakedObjectsSystem system) {
    }
}

