/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.internal.monitor;

import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;

public class MonitorEvent {
    private static int nextSerialId = 1;
    private final int serialId = nextSerialId++;
    private final String message;
    private final String category;
    private DebugString debug;

    public MonitorEvent(String category, String message, DebugInfo[] debugDetails) {
        this.message = message;
        this.category = category;
        this.debug = new DebugString();
        try {
            if (debugDetails != null) {
                for (DebugInfo info : debugDetails) {
                    this.debug.appendTitle(info.debugTitle());
                    this.debug.indent();
                    info.debugData(this.debug);
                    this.debug.unindent();
                }
            }
        }
        catch (RuntimeException e) {
            this.debug.appendException((Exception)e);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSerialId() {
        return this.serialId;
    }

    public String getDebug() {
        return this.debug.toString();
    }

    public String toString() {
        return this.category + ": " + this.message;
    }
}

