/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.internal.monitor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.internal.monitor.Monitor;
import org.nakedobjects.runtime.system.internal.monitor.MonitorEvent;
import org.nakedobjects.runtime.system.internal.monitor.MonitorListener;

public class MonitorListenerImpl
implements MonitorListener {
    private final List<MonitorEvent> requests = new ArrayList<MonitorEvent>();

    public MonitorListenerImpl() {
        Monitor.addListener(this);
    }

    public void postEvent(MonitorEvent event) {
        if (this.requests.size() > 50) {
            this.requests.remove(0);
        }
        this.requests.add(event);
    }

    public void writeHtmlPage(String section, PrintWriter writer) throws IOException {
        int i;
        Assert.assertNotNull((Object)section);
        Assert.assertNotNull((Object)writer);
        String sectionName = section.equals("") ? "Overview" : section;
        writer.println("<HTML><HEAD><TITLE>NOF System Monitor - " + sectionName + "</TITLE></HEAD>");
        writer.println("<BODY>");
        writer.println("<h1>" + sectionName + "</h1>");
        StringBuffer navigation = new StringBuffer("<p>");
        DebugInfo[] infos = NakedObjectsContext.debugSystem();
        for (i = 0; i < infos.length; ++i) {
            String name = infos[i].debugTitle();
            this.appendNavigationLink(navigation, name, i > 0);
        }
        this.appendNavigationLink(navigation, "Requests", true);
        navigation.append("</p>");
        writer.println(navigation);
        writer.println("<pre>");
        if (sectionName.equals("Requests")) {
            i = 1;
            for (MonitorEvent event : this.requests) {
                writer.print("<a href=\"monitor?request=" + event.getSerialId() + "\">");
                writer.print(i++ + ". " + event);
                writer.println("</a>");
            }
        } else if (sectionName.startsWith("request=")) {
            int requestId = Integer.valueOf(sectionName.substring("request=".length()));
            for (MonitorEvent request : this.requests) {
                if (request.getSerialId() != requestId) continue;
                writer.println(request.getDebug());
                break;
            }
        } else {
            for (i = 0; i < infos.length; ++i) {
                if (!infos[i].debugTitle().equals(sectionName)) continue;
                DebugString debug = new DebugString();
                infos[i].debugData(debug);
                writer.println(debug.toString());
                break;
            }
        }
        writer.println("</pre>");
        writer.println(navigation);
        writer.println("</BODY></HTML>");
    }

    private void appendNavigationLink(StringBuffer navigation, String name, boolean appendDivider) throws UnsupportedEncodingException {
        if (appendDivider) {
            navigation.append(" | ");
        }
        navigation.append("<a href=\"monitor?");
        navigation.append(URLEncoder.encode(name, "UTF-8"));
        navigation.append("\">");
        navigation.append(name);
        navigation.append("</a>");
    }

    public void writeTextPage(String section, PrintWriter writer) throws IOException {
        int i;
        Assert.assertNotNull((Object)section);
        Assert.assertNotNull((Object)writer);
        String sectionName = section.equals("") ? "Overview" : section;
        writer.println(sectionName);
        DebugInfo[] infos = NakedObjectsContext.debugSystem();
        if (sectionName.equals("Events")) {
            i = 1;
            for (MonitorEvent event : this.requests) {
                writer.println(i++ + ". " + event);
            }
        } else {
            for (i = 0; i < infos.length; ++i) {
                if (!infos[i].debugTitle().equals(sectionName)) continue;
                DebugString debug = new DebugString();
                infos[i].debugData(debug);
                writer.println(debug.toString());
            }
        }
        writer.print("[Options: ");
        for (i = 0; i < infos.length; ++i) {
            writer.print(infos[i].debugTitle() + " ");
        }
    }
}

