/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.internal.monitor;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.system.internal.monitor.AbstractServerMonitor;
import org.nakedobjects.runtime.system.internal.monitor.MonitorListenerImpl;

public class SocketServerMonitor
extends AbstractServerMonitor {
    private static final int DEFAULT_PORT = 8009;
    private static final String PORT = "nakedobjects.monitor.telnet.port";
    private final MonitorListenerImpl monitor = new MonitorListenerImpl();
    private NakedObjectsSystem system;

    protected int getPort() {
        return NakedObjectsContext.getConfiguration().getInteger(PORT, 8009);
    }

    protected boolean handleRequest(PrintWriter writer, String request) throws IOException {
        String query = URLDecoder.decode(request, "UTF-8");
        if (query.equalsIgnoreCase("bye")) {
            writer.println("Disconnecting...");
            return false;
        }
        if (query.equalsIgnoreCase("shutdown")) {
            writer.println("Shutting down system...");
            this.system.shutdown();
            System.exit(0);
            return false;
        }
        this.monitor.writeTextPage(query, writer);
        writer.print("shutdown bye]\n#");
        writer.flush();
        return true;
    }

    public void setTarget(NakedObjectsSystem system) {
        this.system = system;
    }
}

