/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.userprofile;

import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.runtime.userprofile.Options;
import org.nakedobjects.runtime.userprofile.PerspectiveEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfile
implements DebugInfo {
    private final Options options = new Options();
    private final List<PerspectiveEntry> entries = new ArrayList<PerspectiveEntry>();
    private PerspectiveEntry entry;

    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        for (PerspectiveEntry entry : this.entries) {
            list.add(entry.getName());
        }
        return list;
    }

    public void select(String name) {
        for (PerspectiveEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            this.entry = entry;
            break;
        }
    }

    public PerspectiveEntry getPerspective() {
        if (this.entry == null && this.entries.size() > 0) {
            this.entry = this.entries.get(0);
        }
        return this.entry;
    }

    public PerspectiveEntry getPerspective(String name) {
        for (PerspectiveEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        throw new NakedObjectException("No perspective " + name);
    }

    public void addToPerspectives(PerspectiveEntry perspective) {
        PerspectiveEntry e = new PerspectiveEntry();
        e.copy(perspective);
        this.entries.add(e);
    }

    public void addToOptions(String name, String value) {
        this.options.addOption(name, value);
    }

    public Options getOptions() {
        return this.options;
    }

    public PerspectiveEntry newPerspective(String name) {
        this.entry = new PerspectiveEntry();
        this.entry.setName(name);
        this.entries.add(this.entry);
        return this.entry;
    }

    public void removeCurrent() {
        if (this.entries.size() > 1) {
            this.entries.remove(this.entry);
            this.entry = this.entries.get(0);
        }
    }

    public void copy(UserProfile template) {
        for (PerspectiveEntry entry : template.entries) {
            PerspectiveEntry e = new PerspectiveEntry();
            e.copy(entry);
            this.entries.add(e);
        }
        this.options.copy(template.getOptions());
    }

    public void saveObjects(List<NakedObject> objects) {
        this.entry.save(objects);
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Options");
        debug.indent();
        debug.append((Object)this.options);
        debug.unindent();
        debug.appendTitle("Perspectives");
        for (PerspectiveEntry entry : this.entries) {
            entry.debugData(debug);
        }
    }

    public String debugTitle() {
        return this.toString();
    }
}

