package org.nakedobjects.runtime.authentication.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;


public final class MultiUserExplorationSession implements AuthenticationSession {
    private static final long serialVersionUID = 1L;
    private final List<SimpleSession> registeredUsers = new ArrayList<SimpleSession>();
    private SimpleSession selectedUser;
//    private String name;
//    private String[] roles;
    

    /**
     * Creates a session for the set of user (and roles) listed in the parameter. Takes the form:
     * <p>
     * &lt:userName&gt; [:&lt;role&gt;[|&lt;role&gt;]...], &lt;userName&gt;...
     */
    public MultiUserExplorationSession(String users) {
        final StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            final String token = st.nextToken();
            int end = token.indexOf(':');
            // String[] roles = new String[0];
            List<String> roles = new ArrayList<String>();
            final String userName;
            if (end == -1) {
                userName = token.trim();
            } else {
                userName = token.substring(0, end).trim();
                String roleList = token.substring(end + 1);
                final StringTokenizer st2 = new StringTokenizer(roleList, "|");
                while (st2.hasMoreTokens()) {
                    final String role = st2.nextToken().trim();
                    roles.add(role);
                }
            }
            
            SimpleSession session = new SimpleSession(userName, roles.toArray(new String[roles.size()]));
            registeredUsers.add(session);
            if (selectedUser == null) {
                selectedUser = session;
            }
        }
        if (registeredUsers.size() == 0) {
            throw new NakedObjectException("User string should contain at least one user");
        }
    }

    public void open() {}

    public void close() {}

    public String[] getRoles() {
        return selectedUser.getRoles();
    }

    public String getUserName() {
        return selectedUser.getUserName();
    }

    public String getValidationCode() {
        return "";
    }

    @Override
    public String toString() {
        return new ToString(this).append("name", getUserNames()).append("userCount", registeredUsers.size()).toString();
    }

    public void setCurrentSession(String name) {
        for (SimpleSession user : this.registeredUsers) {
            if (user.getUserName().equals(name)) {
                selectedUser = user;
                break;
            }
        }
    }

    public List<String> getUserNames() {
        List<String> users = new ArrayList<String>();
        for (SimpleSession user : registeredUsers) {
            users.add(user.getUserName());
        }
        return users;
    }

    public boolean hasMultipleUsers() {
        return registeredUsers.size() > 1;
    }

}
// Copyright (c) Naked Objects Group Ltd.
