package org.nakedobjects.runtime.authentication.standard.file;

import java.io.File;

import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.standard.Authenticator;
import org.nakedobjects.runtime.authentication.standard.StandardAuthenticationManagerInstallerAbstract;


public class PasswordFileAuthenticationManagerInstaller extends StandardAuthenticationManagerInstallerAbstract {

    private static final String PASSWORD_FILE_LOCATION_KEY = ConfigurationConstants.ROOT + "component.authenticator.file.location";
    private static final String PASSWORD_FILE_LOCATION_DEFAULT = "config/passwords";
    
    public PasswordFileAuthenticationManagerInstaller() {
        super("file");
    }

    @Override
    protected Authenticator createAuthenticator(final NakedObjectConfiguration configuration) {
        final String passwordFileName = configuration.getString(
                PASSWORD_FILE_LOCATION_KEY, PASSWORD_FILE_LOCATION_DEFAULT);
        return new PasswordFileAuthenticator(new File(passwordFileName));
    }

}
