package org.nakedobjects.runtime.authorization;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacet;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacetAbstract;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacet;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacetAbstract;
import org.nakedobjects.metamodel.spec.identifier.Identified;


public abstract class AuthorizationFacetDecoratorAbstract  extends FacetDecoratorAbstract implements AuthorizationFacetDecorator {
    private final AuthorizationManager authorisationManager;

    public AuthorizationFacetDecoratorAbstract(final AuthorizationManager authorisationManager) {
        this.authorisationManager = authorisationManager;
    }

    public Facet decorate(final Facet facet, final FacetHolder holder) {
        if (!(holder instanceof Identified)) {
            return null;
        }
        Identified identified = (Identified) holder;
        final Identifier identifier = identified.getIdentifier();

        final Class<?> facetType = facet.facetType();
        final FacetHolder facetHolder = facet.getFacetHolder();

        if (facetType == HideForSessionFacet.class) {
            return new HideForSessionFacetAbstract(facetHolder) {
                public String hiddenReason(final AuthenticationSession session) {
                    return authorisationManager.isVisible(session, identifier) ? null : "Not authorized to view";
                }
            };
        }

        if (facetType == DisableForSessionFacet.class) {
            return new DisableForSessionFacetAbstract(facetHolder) {
                public String disabledReason(final AuthenticationSession session) {
                    return authorisationManager.isUsable(session, identifier) ? null : "Not authorized to edit";
                }
            };
        }
        return facet;
    }

    @SuppressWarnings("unchecked")
	public Class<? extends Facet>[] forFacetTypes() {
        return new Class[] { HideForSessionFacet.class, DisableForSessionFacet.class };
    }

}

// Copyright (c) Naked Objects Group Ltd.
