package org.nakedobjects.runtime.authorization.standard;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;


public abstract class AuthorizationManagerAbstract {

    private Authorizor authorisor;

    private boolean isPerspectiveMember(final Identifier identifier) {
        return (identifier.getClassName().equals(""));
    }

    public boolean isUsable(final AuthenticationSession session, final Identifier identifier) {
        if (isPerspectiveMember(identifier)) {
            return true;
        }
        for (int i = 0; i < session.getRoles().length; i++) {
            if (authorisor.isUsable(session.getRoles()[i], identifier)) {
                return true;
            }
        }
        return false;
    }

    public boolean isVisible(final AuthenticationSession session, final Identifier identifier) {
        if (isPerspectiveMember(identifier)) {
            return true;
        }
        for (int i = 0; i < session.getRoles().length; i++) {
            if (authorisor.isVisible(session.getRoles()[i], identifier)) {
                return true;
            }
        }
        return false;
    }

    public void init() {
        authorisor.init();
    }

    public void shutdown() {
        authorisor.shutdown();
    }

    protected void setAuthorisor(final Authorizor authorisor) {
        this.authorisor = authorisor;
    }
}
