package org.nakedobjects.runtime.boot.cmdline.internal;

import org.nakedobjects.runtime.system.DeploymentType;

public final class Arguments {
    
    private Arguments() {}

    static final String TYPE_OPT = "t";
    static final String TYPE_LONG_OPT = "type";
    static final String TYPE_EXPLORATION = DeploymentType.EXPLORATION.name().toLowerCase();
    static final String TYPE_PROTOTYPE = DeploymentType.PROTOTYPE.name().toLowerCase();
    static final String TYPE_STANDALONE = DeploymentType.STANDALONE.name().toLowerCase();
    static final String TYPE_CLIENT = DeploymentType.CLIENT.name().toLowerCase();
    static final String TYPE_SERVER_EXPLORATION = DeploymentType.SERVER_EXPLORATION.name().toLowerCase();
    static final String TYPE_SERVER_PROTOTYPE = DeploymentType.SERVER_PROTOTYPE.name().toLowerCase();
    static final String TYPE_SERVER = DeploymentType.SERVER.name().toLowerCase();
    
    static final String CONFIGURATION_OPT = "c";
    static final String CONFIGURATION_LONG_OPT = "config";
    
    static final String FIXTURE_OPT = "f";
    static final String FIXTURE_LONG_OPT = "fixture";

    static final String HELP_OPT = "h";
    static final String HELP_LONG_OPT = "help";

    static final String REFLECTOR_OPT = "l";
    static final String REFLECTOR_LONG_OPT = "reflector";

    static final String PROGMODEL_OPT = "m";
    static final String PROGMODEL_LONG_OPT = "progmodel";

    static final String OBJECT_PERSISTENCE_OPT = "r";
    static final String OBJECT_PERSISTENCE_LONG_OPT = "object-persistor";

    static final String USER_PROFILE_PERSISTENCE_OPT = "e";
    static final String USER_PROFILE_PERSISTENCE_LONG_OPT = "profile-persistor";

    static final String VIEWER_OPT = "v";
    static final String VIEWER_LONG_OPT = "viewer";

    static final String CONNECTION_OPT = "x";
    static final String CONNECTION_LONG_OPT = "connector";

    static final String NO_SPLASH_OPT = "s";
    static final String NO_SPLASH_LONG_OPT = "nosplash";
    
    static final String USER_OPT = "u";
    static final String USER_LONG_OPT = "user";

    static final String PASSWORD_OPT = "p";
    static final String PASSWORD_LONG_OPT = "password";

    static final String DIAGNOSTICS_OPT = "diagnostics";
    static final String VERSION_OPT = "version";
    static final String DEBUG_OPT = "debug";
    static final String VERBOSE_OPT = "verbose";
    static final String QUIET_OPT = "quiet";
    
    static final String ADDITIONAL_PROPERTY = "D";

}
