package org.nakedobjects.runtime.client;

import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.system.DeploymentType;


public interface NakedObjectClient {

    /**
     * Indicates to the component that it is to initialise itself as it will soon be receiving requests.
     */
    void run();

    void setTitle(String title);

	void setDeploymentType(DeploymentType deploymentType);

    /**
     * Optionally set if in exploration or prototyping mode.
     */
    public void setLogonFixture(LogonFixture logonFixture);

    /**
     * Optionally set if <tt>--user</tt> and <tt>--password</tt> are provided via command line arguments.
     * 
     * @param authenticationRequest
     */
    void setAuthenticationRequestViaArgs(AuthenticationRequest authenticationRequest);

    void setAuthenticationManager(AuthenticationManager authenticationManager);

    /**
     * Indicates to the client that no more requests will be accepted from it and it should safely release any
     * services it has hold of.
     * 
     * @deprecated
     */
    @Deprecated
    void shutdown();


}

// Copyright (c) Naked Objects Group Ltd.
