package org.nakedobjects.runtime.fixturesinstaller;

import org.nakedobjects.applib.switchuser.SwitchUserService;
import org.nakedobjects.applib.switchuser.SwitchUserServiceAware;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;
import org.nakedobjects.runtime.context.NakedObjectsContext;


public class SwitchUserServiceImpl implements SwitchUserService {

    public SwitchUserServiceImpl() {
    }

    public void switchUser(final String username, final String... roles) {
    	NakedObjectsContext.getTransactionManager().endTransaction();
    	NakedObjectsContext.closeSession();
        final AuthenticationSession session = new SimpleSession(username, roles);
        NakedObjectsContext.openSession(session);
        NakedObjectsContext.getTransactionManager().startTransaction();
    }

	public void injectInto(Object fixture) {
    	if (fixture instanceof SwitchUserServiceAware) {
    		SwitchUserServiceAware serviceAware = (SwitchUserServiceAware) fixture;
    		serviceAware.setService(this);
    	}
	}
}

// Copyright (c) Naked Objects Group Ltd.
