package org.nakedobjects.runtime.help;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.help.HelpFacet;
import org.nakedobjects.metamodel.spec.identifier.Identified;


public class StandardHelpFacetDecorator  extends FacetDecoratorAbstract implements HelpFacetDecorator {
    private final HelpManager helpManager;

    public StandardHelpFacetDecorator(final HelpManager manager) {
        helpManager = manager;
    }

    public Facet decorate(final Facet facet, final FacetHolder holder) {
        final Identifier identifier = ((Identified) holder).getIdentifier();
        if (facet.facetType() == HelpFacet.class) {
            final String lookupHelp = helpManager.help(identifier);
            if (lookupHelp != null) {
                return new HelpFacetLookup(lookupHelp, facet.getFacetHolder());
            }
        }

        return facet;
    }

    public Class<? extends Facet>[] forFacetTypes() {
        return new Class[] { HelpFacet.class };
    }
}

// Copyright (c) Naked Objects Group Ltd.
