package org.nakedobjects.runtime.installers;

import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.provider.NakedObjectConfigurationProvider;
import org.nakedobjects.metamodel.config.provider.NakedObjectConfigurationProviderAware;

public abstract class InstallerAbstract implements Installer, NakedObjectConfigurationProviderAware {

    private NakedObjectConfigurationProvider configurationProvider;
    private NakedObjectConfiguration configuration;
    
    /**
     * Either this method or {@link #setConfiguration(NakedObjectConfiguration)} should be called
     * prior to calling {@link #getConfiguration()}.
     * 
     * <p>
     * If a {@link #setConfiguration(NakedObjectConfiguration) configuration} has already
     * been provided, then throws {@link IllegalStateException}.
     */
    public void setConfigurationProvider(NakedObjectConfigurationProvider configurationProvider) {
    	if (configuration != null) {
    		throw new IllegalStateException("A NakedObjectConfiguration has already been provided.");
    	}
        this.configurationProvider = configurationProvider;
    }

    /**
     * Either this method or {@link #setConfigurationProvider(NakedObjectConfigurationProvider)} should be
     * called prior to calling {@link #getConfiguration()}.
     * 
     * <p>
     * If a {@link #setConfigurationProvider(NakedObjectConfigurationProvider) configuration provider} has already
     * been provided, then throws {@link IllegalStateException}.
     */
    public void setConfiguration(NakedObjectConfiguration configuration) {
    	if (configurationProvider != null) {
    		throw new IllegalStateException("A NakedObjectConfiguration has already been provided.");
    	}
		this.configuration = configuration;
	}

    /**
     * Returns a <i>snapshot</i> of the current configuration provided by the
     * {@link #setConfigurationProvider(NakedObjectConfigurationProvider) injected}
     * {@link NakedObjectConfigurationProvider}.
     * 
     * <p>
     * Implementation note: the implementation is in fact just {@link InstallerLookupImpl}.
     */
    public NakedObjectConfiguration getConfiguration() {
        if (configurationProvider != null) {
        	return configurationProvider.getConfiguration();
        } else if (configuration != null) {
            	return configuration;
        } else {
        	throw new IllegalStateException("Neither a ConfigurationProvider nor Configuration has not been provided");
        }
    }
}


// Copyright (c) Naked Objects Group Ltd.
