package org.nakedobjects.runtime.installers;

import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoader;
import org.nakedobjects.metamodel.config.provider.NakedObjectConfigurationProvider;
import org.nakedobjects.metamodel.specloader.FacetDecoratorInstaller;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.runtime.authentication.AuthenticationManagerInstaller;
import org.nakedobjects.runtime.authorization.AuthorizationFacetDecoratorInstaller;
import org.nakedobjects.runtime.client.NakedObjectClientInstaller;
import org.nakedobjects.runtime.fixturesinstaller.FixturesInstaller;
import org.nakedobjects.runtime.imageloader.TemplateImageLoaderInstaller;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstaller;
import org.nakedobjects.runtime.persistence.services.ServicesInstaller;
import org.nakedobjects.runtime.remoting.ClientConnectionInstaller;
import org.nakedobjects.runtime.remoting.ServerListenerInstaller;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.userprofile.UserProfileStoreInstaller;


/**
 * The installers correspond more-or-less to the configurable top-level components of
 * {@link NakedObjectsSystem}.
 */
public interface InstallerLookup extends NakedObjectConfigurationProvider, InstallerRepository {

	///////////////////////////////////////////////////////////
	// metamodel
	///////////////////////////////////////////////////////////
	
    public NakedObjectReflectorInstaller reflectorInstaller(final String requested);

    
	///////////////////////////////////////////////////////////
	// framework
	///////////////////////////////////////////////////////////

    public AuthenticationManagerInstaller authenticatorInstaller(String requested);

    public AuthorizationFacetDecoratorInstaller authorisationInstaller(String requested);

    public FixturesInstaller fixturesInstaller(String requested);

    public ServicesInstaller servicesInstaller(final String requested);

    public TemplateImageLoaderInstaller templateImageLoaderInstaller(String requested);

    public PersistenceMechanismInstaller persistenceMechanismInstaller(final String requested, final DeploymentType deploymentType);

    public UserProfileStoreInstaller userProfilePersistenceMechanismInstaller(final String requested, DeploymentType deploymentType);

    public NakedObjectClientInstaller clientInstaller(final String requested, final String defaultName);

    /**
     * Client-side of <tt>remoting</tt>, specifying how to access the server.
     * 
     * <p>
     * Note that this lookup is called in three different contexts:
     * <ul>
     * <li> the <tt>NakedObjectsExecutionContextFactoryUsingInstallers</tt> uses this to lookup
     *      the {@link PersistenceMechanismInstaller} (may be a <tt>ProxyPersistor</tt>)</li>
     * <li> the <tt>NakedObjectsExecutionContextFactoryUsingInstallers</tt> also uses this to lookup
     *      the {@link FacetDecoratorInstaller}; adds in remoting facets.</li>
     * <li> the <tt>NakedObjectsSystemUsingInstallers</tt> uses this to lookup the {@link AuthenticationManagerInstaller}.</li>
     * </ul>
     */
    public ClientConnectionInstaller clientConnectionInstaller(final String requested);

    /**
     * Server-side of <tt>remoting</tt>
     */
    public ServerListenerInstaller listenerInstaller(final String requested);

    
	///////////////////////////////////////////////////////////
	// framework - generic
	///////////////////////////////////////////////////////////

    public <T extends Installer> T getInstaller(final Class<T> cls, final String requested);

    public <T extends Installer> T getInstaller(final Class<T> cls);
    
    public <T extends Installer> T getInstaller(final String implClassName);


	///////////////////////////////////////////////////////////
	// configuration
	///////////////////////////////////////////////////////////

    /**
     * Injects self into candidate
     */
    public <T> T configure(T candidate);


    /**
     * Returns a <i>snapshot</i> of the current {@link NakedObjectConfiguration}.
     * 
     * <p>
     * The {@link NakedObjectConfiguration} could subsequently be appended to if 
     * further {@link Installer}s are loaded.
     */
    public NakedObjectConfiguration getConfiguration();

    public void setConfigurationLoader(ConfigurationLoader configurationLoader);

    

}

// Copyright (c) Naked Objects Group Ltd.
