package org.nakedobjects.runtime.installers;

import org.nakedobjects.metamodel.config.ConfigurationConstants;

public final class InstallerLookupConstants {
    

    private InstallerLookupConstants() {}

    public static final String PROPERTY_BASE = ConfigurationConstants.ROOT + "component.";


    public static final String AUTHENTICATION_KEY = PROPERTY_BASE + "authentication";
    public static final String AUTHENTICATION_DEFAULT = "file";

    public static final String AUTHORISATION_KEY = PROPERTY_BASE + "authorisation";
    public static final String AUTHORISATION_DEFAULT = "file";

    public static final String FIXTURES_KEY = PROPERTY_BASE + "fixtures";
    public static final String FIXTURES_DEFAULT = "configuration";

    public static final String IMAGE_LOADER_KEY = PROPERTY_BASE + "image-loader";
    public static final String IMAGE_LOADER_DEFAULT = "awt";

    public static final String PERSISTOR_KEY = PROPERTY_BASE + "persistor";
    public static final String PERSISTOR_NON_PRODUCTION_DEFAULT = "in-memory";
    public static final String PERSISTOR_PRODUCTION_DEFAULT = "xml";
    
    public static final String USER_PROFILE_STORE_KEY = PROPERTY_BASE + "user-profile-persistor";
    public static final String USER_PROFILE_STORE_NON_PRODUCTION_DEFAULT = "in-memory";
    public static final String USER_PROFILE_STORE_PRODUCTION_DEFAULT = "xml";


    public static final String REFLECTOR_KEY = PROPERTY_BASE + "reflector";
    public static final String REFLECTOR_DEFAULT = "java";
    
    public static final String REMOTING_CLIENT_CONNECTION_KEY = PROPERTY_BASE + "client-connection";
    public static final String REMOTING_CLIENT_CONNECTION_DEFAULT = "xstream";
    
    public static final String SERVICES_KEY = PROPERTY_BASE + "services";
    public static final String SERVICES_DEFAULT = "configuration";

    public static final String LISTENER_KEY = PROPERTY_BASE + "listener";

    public static final String VIEWER_KEY = PROPERTY_BASE + "viewer";

}


// Copyright (c) Naked Objects Group Ltd.
