package org.nakedobjects.runtime.memento;

import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;


class CollectionData extends Data {
    private final static long serialVersionUID = 1L;
    final Data[] elements;

    public CollectionData(final Oid oid, ResolveState resolveState, final String className, final Data[] elements) {
        super(oid, resolveState.name(), className);
        this.elements = elements;
    }

    public CollectionData(final ByteDecoder decoder) {
        super(decoder);

        final int no = decoder.getInt();
        elements = new Data[no];
        for (int i = 0; i < no; i++) {
            elements[i] = (Data) decoder.getObject();
        }
    }

    @Override
    public void debug(final DebugString debug) {
        super.debug(debug);
        for (int i = 0; i < elements.length; i++) {
            debug.appendln("" + i + 1, elements[i]);

            // TODO recurse!
        }
    }

    @Override
    public String toString() {
        final StringBuffer str = new StringBuffer("(");
        for (int i = 0; i < elements.length; i++) {
            str.append((i > 0) ? "," : "");
            str.append(elements[i]);
        }
        str.append(")");
        return str.toString();
    }

    @Override
    public void encode(final ByteEncoder encoder) {
        super.encode(encoder);

        final int no = elements.length;
        encoder.add(no);
        for (int i = 0; i < no; i++) {
            elements[i].encode(encoder);
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
